/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.utils;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import hu.xannosz.betterminecarts.utils.Fuel;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuelHolder {
    private static final Logger log = LoggerFactory.getLogger(FuelHolder.class);
    public static final String FUEL_COLOR_KEY = "BETTER_MINECARTS_FUEL_COLOR";
    public static final String AMOUNT_IN_ONE_ITEM_IN_MILLI_BUCKETS_KEY = "BETTER_MINECARTS_AMOUNT_IN_ONE_ITEM_IN_MILLI_BUCKETS";
    public static final String ENERGY_IN_ONE_MILLI_BUCKET_KEY = "BETTER_MINECARTS_ENERGY_IN_ONE_MILLI_BUCKET";
    public static final String LEFTOVER_ITEM_KEY = "BETTER_MINECARTS_LEFTOVER_ITEM";
    private static final FuelHolder INSTANCE = new FuelHolder();
    private final List<Fuel> fuels = new ArrayList<Fuel>();

    private FuelHolder() {
        Path configPath = FMLPaths.GAMEDIR.get().resolve("config/betterminecartsfuel.json");
        if (!configPath.toFile().exists()) {
            this.fuels.add(new Fuel(148, 145, 70, 127, 200, 10, "betterminecarts:bio_diesel_fuel", "minecraft:glass_bottle"));
            try {
                configPath.toFile().createNewFile();
                FileUtils.writeStringToFile((File)configPath.toFile(), (String)new GsonBuilder().setPrettyPrinting().create().toJson(this.fuels), (Charset)Charsets.UTF_8);
            }
            catch (Exception ex) {
                log.error("Problem with fuel json parsing", (Throwable)ex);
            }
        } else {
            try {
                JsonElement dataObject = JsonParser.parseString((String)FileUtils.readFileToString((File)configPath.toFile(), (Charset)Charsets.UTF_8));
                this.fuels.addAll(Arrays.asList((Fuel[])new Gson().fromJson(dataObject, Fuel[].class)));
            }
            catch (Exception ex) {
                log.error("Problem with fuel json parsing", (Throwable)ex);
            }
        }
    }

    public boolean isFuel(ItemStack item) {
        if (item.m_41784_().m_128441_(ENERGY_IN_ONE_MILLI_BUCKET_KEY)) {
            return true;
        }
        return this.getFuelFromList(item) != null;
    }

    public Item getLeftover(ItemStack item) {
        if (item.m_41784_().m_128441_(LEFTOVER_ITEM_KEY)) {
            return this.getItemFromQualifiedName(item.m_41784_().m_128461_(LEFTOVER_ITEM_KEY));
        }
        if (!this.isFuel(item)) {
            return Items.f_41852_;
        }
        return this.getItemFromQualifiedName(this.getFuelFromList(item).getLeftoverItemQualifiedName());
    }

    public int getFuelAmount(ItemStack item) {
        if (item.m_41784_().m_128441_(AMOUNT_IN_ONE_ITEM_IN_MILLI_BUCKETS_KEY)) {
            return item.m_41784_().m_128451_(AMOUNT_IN_ONE_ITEM_IN_MILLI_BUCKETS_KEY);
        }
        if (!this.isFuel(item)) {
            return 0;
        }
        return this.getFuelFromList(item).getAmountInOneItemInMilliBuckets();
    }

    public int getFuelPower(ItemStack item) {
        if (item.m_41784_().m_128441_(ENERGY_IN_ONE_MILLI_BUCKET_KEY)) {
            return item.m_41784_().m_128451_(ENERGY_IN_ONE_MILLI_BUCKET_KEY);
        }
        if (!this.isFuel(item)) {
            return 0;
        }
        return this.getFuelFromList(item).getEnergyInOneMilliBucket();
    }

    public int getFuelColor(ItemStack item) {
        if (item.m_41784_().m_128441_(FUEL_COLOR_KEY)) {
            return item.m_41784_().m_128451_(FUEL_COLOR_KEY);
        }
        if (!this.isFuel(item)) {
            return -1;
        }
        Fuel fuel = this.getFuelFromList(item);
        return fuel.getFuelColorRed() << 24 | fuel.getFuelColorGreen() << 16 | fuel.getFuelColoBlue() << 8 | fuel.getFuelColorAlpha();
    }

    private Fuel getFuelFromList(ItemStack item) {
        for (Fuel fuel : this.fuels) {
            if (!this.getItemFromQualifiedName(fuel.getItemQualifiedName()).equals(item.m_41720_())) continue;
            return fuel;
        }
        return null;
    }

    private Item getItemFromQualifiedName(String name) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(name));
    }

    public static FuelHolder getINSTANCE() {
        return INSTANCE;
    }
}

