/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.item;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.DieselLocomotive;
import hu.xannosz.betterminecarts.entity.ElectricLocomotive;
import hu.xannosz.betterminecarts.entity.LocomotiveType;
import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractLocomotiveItem
extends Item {
    public static final String TOP_COLOR_TAG = "topColor";
    public static final String BOTTOM_COLOR_TAG = "bottomColor";
    private final LocomotiveType locomotiveType;
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        @NotNull
        public ItemStack m_7498_(BlockSource blockSource, @NotNull ItemStack itemStack) {
            double d3;
            BlockPos blockpos;
            BlockState blockstate;
            RailShape railshape;
            Direction direction = (Direction)blockSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = blockSource.m_7727_();
            double d0 = blockSource.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = Math.floor(blockSource.m_7098_()) + (double)direction.m_122430_();
            double d2 = blockSource.m_7094_() + (double)direction.m_122431_() * 1.125;
            MinecartColor topColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(AbstractLocomotiveItem.TOP_COLOR_TAG));
            MinecartColor bottomColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(AbstractLocomotiveItem.BOTTOM_COLOR_TAG));
            if (topColor == null || bottomColor == null) {
                topColor = ((AbstractLocomotiveItem)itemStack.m_41720_()).locomotiveType.getTopColor();
                bottomColor = ((AbstractLocomotiveItem)itemStack.m_41720_()).locomotiveType.getBottomColor();
            }
            RailShape railShape = railshape = (blockstate = level.m_8055_(blockpos = blockSource.m_7961_().m_121945_(direction))).m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.m_204336_(BlockTags.f_13034_)) {
                d3 = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                if (!blockstate.m_60795_() || !level.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.defaultDispenseItemBehavior.m_6115_(blockSource, itemStack);
                }
                BlockState blockState = level.m_8055_(blockpos.m_7495_());
                RailShape railShape2 = blockState.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railShape2.m_61745_() ? -0.4 : -0.9;
            }
            AbstractLocomotive abstractLocomotive = switch (((AbstractLocomotiveItem)itemStack.m_41720_()).locomotiveType) {
                case LocomotiveType.ELECTRIC -> new ElectricLocomotive((Level)level, d0, d1 + d3, d2, topColor, bottomColor);
                case LocomotiveType.STEAM -> new SteamLocomotive((Level)level, d0, d1 + d3, d2, topColor, bottomColor);
                case LocomotiveType.DIESEL -> new DieselLocomotive((Level)level, d0, d1 + d3, d2, topColor, bottomColor);
                default -> null;
            };
            if (itemStack.m_41788_()) {
                abstractLocomotive.m_6593_(itemStack.m_41786_());
                abstractLocomotive.m_20340_(true);
            }
            abstractLocomotive.setStartDirection(direction);
            level.m_7967_((Entity)abstractLocomotive);
            itemStack.m_41774_(1);
            return itemStack;
        }

        protected void m_6823_(BlockSource p_42947_) {
            p_42947_.m_7727_().m_46796_(1000, p_42947_.m_7961_(), 0);
        }
    };

    public AbstractLocomotiveItem(LocomotiveType locomotiveType) {
        super(new Item.Properties().m_41487_(1));
        this.locomotiveType = locomotiveType;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        BlockPos blockpos = useOnContext.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        MinecartColor topColor = MinecartColor.getFromLabel(useOnContext.m_43722_().m_41784_().m_128461_(TOP_COLOR_TAG));
        MinecartColor bottomColor = MinecartColor.getFromLabel(useOnContext.m_43722_().m_41784_().m_128461_(BOTTOM_COLOR_TAG));
        if (topColor == null || bottomColor == null) {
            topColor = this.locomotiveType.getTopColor();
            bottomColor = this.locomotiveType.getBottomColor();
        }
        if (!blockstate.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = useOnContext.m_43722_();
        if (!level.f_46443_) {
            RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            AbstractLocomotive abstractLocomotive = switch (this.locomotiveType) {
                case LocomotiveType.ELECTRIC -> this.createElectricLocomotive(bottomColor, topColor, level, blockpos, d0);
                case LocomotiveType.STEAM -> this.createSteamLocomotive(bottomColor, topColor, level, blockpos, d0);
                case LocomotiveType.DIESEL -> this.createDieselLocomotive(bottomColor, topColor, level, blockpos, d0);
                default -> null;
            };
            if (itemstack.m_41788_()) {
                abstractLocomotive.m_6593_(itemstack.m_41786_());
                abstractLocomotive.m_20340_(true);
            }
            abstractLocomotive.setStartDirection(useOnContext.m_8125_());
            level.m_7967_((Entity)abstractLocomotive);
            level.m_220407_(GameEvent.f_157810_, blockpos, GameEvent.Context.m_223719_((Entity)useOnContext.m_43723_(), (BlockState)level.m_8055_(blockpos.m_7495_())));
        }
        itemstack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        MinecartColor topColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(TOP_COLOR_TAG));
        MinecartColor bottomColor = MinecartColor.getFromLabel(itemStack.m_41784_().m_128461_(BOTTOM_COLOR_TAG));
        if (topColor == null || bottomColor == null) {
            topColor = this.locomotiveType.getTopColor();
            bottomColor = this.locomotiveType.getBottomColor();
        }
        components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + topColor.getLabel())).m_130940_(topColor.getLabelColor()));
        components.add((Component)Component.m_237115_((String)("text.betterminecarts.locomotive.color." + bottomColor.getLabel())).m_130940_(bottomColor.getLabelColor()));
        super.m_7373_(itemStack, level, components, tooltipFlag);
    }

    private AbstractLocomotive createElectricLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new ElectricLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    private AbstractLocomotive createSteamLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new SteamLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    private AbstractLocomotive createDieselLocomotive(MinecartColor bottom, MinecartColor top, Level level, BlockPos blockpos, double d0) {
        return new DieselLocomotive(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, top, bottom);
    }

    @NotNull
    public String m_5524_() {
        return "item.betterminecarts." + this.getLocomotiveName();
    }

    public String getLocomotiveName() {
        return this.locomotiveType.getName();
    }
}

