/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.config;

import com.talhanation.smallships.SmallShipsMod;
import com.talhanation.smallships.config.forge.SmallShipsConfigImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SmallShipsConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static final List<Consumer<ModConfig>> commonSchematicUpdater;
    private static final List<Consumer<ModConfig>> clientSchematicUpdater;

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerConfigs(String modId, ModConfig.Type type, IConfigSpec<?> spec) {
        void var2_2;
        void var1_1;
        SmallShipsConfigImpl.registerConfigs(modId, (ModConfig.Type)var1_1, var2_2);
    }

    private static void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(" This holds the schematic version for internal purposes. DO NOT TOUCH!");
        Common.schematicVersion = builder.define("schematicVersion", (Object)2);
        builder.comment(" This category holds configs that define ship behaviour.");
        builder.push("Ship");
        builder.comment("This category holds configs that define general ship behaviour.");
        builder.push("General");
        Common.shipGeneralSailCooldown = builder.define("shipGeneralSailCooldown", (Object)30);
        Common.shipGeneralCollisionDamage = builder.define("shipGeneralCollisionDamage", (Object)7.5);
        Common.shipGeneralDoItemDrop = builder.define("shipGeneralDoItemDrop", true);
        builder.comment("General speed modifier for ships.");
        builder.push("Modifier");
        builder.comment("Maximum speed penalty for a filled container in percent.");
        Common.shipGeneralContainerModifier = builder.define("shipGeneralContainerModifier", (Object)10.0);
        builder.comment("Speed bonus for a paddle ship while paddling in percent.");
        Common.shipGeneralPaddlingModifier = builder.define("shipGeneralPaddlingModifier", (Object)35.0);
        builder.pop();
        builder.comment("This category holds configs that define behaviour of fleeing water animals.");
        builder.push("Fleeing Water Animals");
        Common.waterAnimalFleeRadius = builder.define("waterAnimalFleeRadius", (Object)15.0);
        Common.waterAnimalFleeSpeed = builder.define("waterAnimalFleeSpeed", (Object)1.5);
        Common.waterAnimalFleeDistance = builder.define("waterAnimalFleeDistance", (Object)10.0);
        builder.pop();
        builder.pop();
        builder.push("Cog");
        builder.comment("Default attributes for the Cog. Speed in km/h, Health in default mc health points");
        builder.push("Attributes");
        Common.shipAttributeCogMaxHealth = builder.define("shipAttributeCogMaxHealth", (Object)300.0);
        Common.shipAttributeCogMaxSpeed = builder.define("shipAttributeCogMaxSpeed", (Object)30.0);
        Common.shipAttributeCogMaxReverseSpeed = builder.define("shipAttributeCogMaxReverseSpeed", (Object)0.1);
        Common.shipAttributeCogMaxRotationSpeed = builder.define("shipAttributeCogMaxRotationSpeed", (Object)4.5);
        Common.shipAttributeCogAcceleration = builder.define("shipAttributeCogAcceleration", (Object)0.015);
        Common.shipAttributeCogRotationAcceleration = builder.define("shipAttributeCogRotationAcceleration", (Object)0.7);
        builder.pop();
        builder.comment("Default configs for the container of the Cog.");
        builder.push("Container");
        builder.comment("Set container size for the Cog (value must be divisible by 9 and bigger than 0).");
        Common.shipContainerCogContainerSize = builder.define("shipContainerCogContainerSize", (Object)108, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) % 9 == 0 && i > 0;
        });
        builder.pop();
        builder.comment("Cog specific speed modifier.");
        builder.push("Modifier");
        builder.comment("-1 = none, 0 = cold, 1 = neutral or 2 = warm Biomes");
        Common.shipModifierCogBiome = builder.define("shipModifierCogBiome", (Object)0, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) <= 2 && i >= -1;
        });
        builder.pop();
        builder.pop();
        builder.push("Brigg");
        builder.comment("Default attributes for the Brigg. Speed in km/h, Health in default mc health points");
        builder.push("Attributes");
        Common.shipAttributeBriggMaxHealth = builder.define("shipAttributeBriggMaxHealth", (Object)450.0);
        Common.shipAttributeBriggMaxSpeed = builder.define("shipAttributeBriggMaxSpeed", (Object)35.0);
        Common.shipAttributeBriggMaxReverseSpeed = builder.define("shipAttributeBriggMaxReverseSpeed", (Object)0.1);
        Common.shipAttributeBriggMaxRotationSpeed = builder.define("shipAttributeBriggMaxRotationSpeed", (Object)4.0);
        Common.shipAttributeBriggAcceleration = builder.define("shipAttributeBriggAcceleration", (Object)0.015);
        Common.shipAttributeBriggRotationAcceleration = builder.define("shipAttributeBriggRotationAcceleration", (Object)0.55);
        builder.pop();
        builder.comment("Default configs for the container of the Brigg.");
        builder.push("Container");
        builder.comment("Set container size for the Brigg (value must be divisible by 9 and bigger than 0).");
        Common.shipContainerBriggContainerSize = builder.define("shipContainerBriggContainerSize", (Object)162, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) % 9 == 0 && i > 0;
        });
        builder.pop();
        builder.comment("Brigg specific speed modifier.");
        builder.push("Modifier");
        builder.comment("-1 = none, 0 = cold, 1 = neutral or 2 = warm Biomes");
        Common.shipModifierBriggBiome = builder.define("shipModifierBriggBiome", (Object)0, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) <= 2 && i >= -1;
        });
        builder.pop();
        builder.pop();
        builder.push("Galley");
        builder.comment("Default attributes for the Galley. Speed in km/h, Health in default mc health points");
        builder.push("Attributes");
        Common.shipAttributeGalleyMaxHealth = builder.define("shipAttributeGalleyMaxHealth", (Object)200.0);
        Common.shipAttributeGalleyMaxSpeed = builder.define("shipAttributeGalleyMaxSpeed", (Object)30.0);
        Common.shipAttributeGalleyMaxReverseSpeed = builder.define("shipAttributeGalleyMaxReverseSpeed", (Object)0.1);
        Common.shipAttributeGalleyMaxRotationSpeed = builder.define("shipAttributeGalleyMaxRotationSpeed", (Object)5.0);
        Common.shipAttributeGalleyAcceleration = builder.define("shipAttributeGalleyAcceleration", (Object)0.015);
        Common.shipAttributeGalleyRotationAcceleration = builder.define("shipAttributeGalleyRotationAcceleration", (Object)1.0);
        builder.pop();
        builder.comment("Default configs for the container of the Galley.");
        builder.push("Container");
        builder.comment("Set container size for the Galley (value must be divisible by 9 and bigger than 0).");
        Common.shipContainerGalleyContainerSize = builder.define("shipContainerGalleyContainerSize", (Object)54, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) % 9 == 0 && i > 0;
        });
        builder.pop();
        builder.comment("Galley specific speed modifier.");
        builder.push("Modifier");
        builder.comment("-1 = none, 0 = cold, 1 = neutral or 2 = warm Biomes");
        Common.shipModifierGalleyBiome = builder.define("shipModifierGalleyBiome", (Object)2, e -> {
            Integer i;
            return e instanceof Integer && (i = (Integer)e) <= 2 && i >= -1;
        });
        builder.pop();
        builder.pop();
        builder.pop();
    }

    private static void setupClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(" This holds the schematic version for internal purposes. DO NOT TOUCH!");
        Common.schematicVersion = builder.define("schematicVersion", (Object)1);
        builder.comment(" This category holds configs that define ship behaviour.");
        builder.push("Ship");
        builder.comment("This category holds configs that define general ship behaviour.");
        builder.push("General");
        builder.comment("General camera settings for ships.");
        builder.push("Camera");
        builder.comment("Zoom camera settings for third person view in ships.");
        builder.push("Zoom");
        builder.comment("Generally enable the zooming feature.");
        Client.shipGeneralCameraZoomEnable = builder.define("shipGeneralCameraZoomEnable", true);
        builder.comment("Set maximum distance of zoom (value must be smaller than or equal to 50.0).");
        Client.shipGeneralCameraZoomMax = builder.define("shipGeneralCameraZoomMax", (Object)20.0, e -> {
            Double d;
            return e instanceof Double && (d = (Double)e) <= 50.0 && d >= 1.0;
        });
        builder.comment("Set minimum distance of zoom (value must be bigger than or equal to 1.0).");
        Client.shipGeneralCameraZoomMin = builder.define("shipGeneralCameraZoomMin", (Object)5.0, e -> {
            Double d;
            return e instanceof Double && (d = (Double)e) <= 50.0 && d >= 1.0;
        });
        builder.pop();
        builder.comment("Automatically enable third person camera when entering a ship.");
        Client.shipGeneralCameraAutoThirdPerson = builder.define("shipGeneralCameraAutoThirdPerson", true);
        builder.pop();
        builder.pop();
        builder.pop();
        builder.comment(" This category holds configs that define general mod settings.");
        builder.push("General");
        builder.comment("Enable smallships creative tab in the creative inventory (only takes effect after restart).");
        Common.smallshipsItemGroupEnable = builder.define("smallshipsItemGroupEnable", false);
        builder.pop();
    }

    public static void updateConfig(ModConfig config) {
        int oldSchematicVersion = SmallShipsConfig.getSchematicVersion(config);
        boolean hasBeenUpdated = switch (config.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.Type.COMMON -> SmallShipsConfig.updateConfig(config, commonSchematicUpdater);
            case ModConfig.Type.CLIENT -> SmallShipsConfig.updateConfig(config, clientSchematicUpdater);
            case ModConfig.Type.SERVER -> false;
        };
        int newSchematicVersion = SmallShipsConfig.getSchematicVersion(config);
        if (hasBeenUpdated) {
            SmallShipsMod.LOGGER.warn("Updated config values of " + config.getFileName() + " from schematic version " + oldSchematicVersion + " to " + newSchematicVersion + "!");
        }
    }

    private static boolean updateConfig(ModConfig config, List<Consumer<ModConfig>> schematicUpdater) {
        if (SmallShipsConfig.getSchematicVersion(config) < schematicUpdater.size() + 1) {
            for (int i = SmallShipsConfig.getSchematicVersion(config) - 1; i < schematicUpdater.size(); ++i) {
                int j = 0;
                while (true) {
                    try {
                        String[] fileNameExtensionPair = config.getFileName().split("\\.");
                        String backupFileName = fileNameExtensionPair[0] + "-sv" + (i + 1) + (String)(j == 0 ? "" : "-" + j) + "." + fileNameExtensionPair[1] + ".bak";
                        Files.copy(config.getFullPath(), config.getFullPath().resolveSibling(backupFileName), new CopyOption[0]);
                        SmallShipsMod.LOGGER.info("Backed up previous config version: " + backupFileName);
                    }
                    catch (FileAlreadyExistsException ignored) {
                        if (++j <= 99) continue;
                        throw new RuntimeException("Delete the " + config.getFileName() + " config files!!!");
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not create backup of " + config.getFileName() + " during schematicVersion update process, crashing for safety! Please backup the config file if needed and remove it from the config folder. " + e);
                    }
                    break;
                }
                SmallShipsConfig.setSchematicVersion(config, i + 2);
                schematicUpdater.get(i).accept(config);
            }
            config.save();
            return true;
        }
        return false;
    }

    private static int getSchematicVersion(ModConfig config) {
        return config.getConfigData().getInt("schematicVersion");
    }

    private static void setSchematicVersion(ModConfig config, int i) {
        config.getConfigData().set("schematicVersion", (Object)i);
    }

    private static <T> void resetEntry(ModConfig config, ForgeConfigSpec.ConfigValue<T> value) {
        config.getConfigData().set(value.getPath(), value.getDefault());
    }

    static {
        ForgeConfigSpec.Builder commonConfigBuilder = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder clientConfigBuilder = new ForgeConfigSpec.Builder();
        SmallShipsConfig.setupCommonConfig(commonConfigBuilder);
        SmallShipsConfig.setupClientConfig(clientConfigBuilder);
        COMMON_SPEC = commonConfigBuilder.build();
        CLIENT_SPEC = clientConfigBuilder.build();
        commonSchematicUpdater = new ArrayList<Consumer<ModConfig>>();
        commonSchematicUpdater.add(config -> {
            SmallShipsConfig.resetEntry(config, Common.shipGeneralContainerModifier);
            SmallShipsConfig.resetEntry(config, Common.shipGeneralPaddlingModifier);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeBriggMaxSpeed);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeBriggMaxRotationSpeed);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeBriggRotationAcceleration);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeGalleyMaxSpeed);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeCogMaxSpeed);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeCogMaxRotationSpeed);
            SmallShipsConfig.resetEntry(config, Common.shipAttributeCogRotationAcceleration);
        });
        clientSchematicUpdater = new ArrayList<Consumer<ModConfig>>();
    }

    public static class Common {
        public static ForgeConfigSpec.ConfigValue<Integer> schematicVersion;
        public static ForgeConfigSpec.ConfigValue<Integer> shipGeneralSailCooldown;
        public static ForgeConfigSpec.ConfigValue<Double> shipGeneralCollisionDamage;
        public static ForgeConfigSpec.BooleanValue shipGeneralDoItemDrop;
        public static ForgeConfigSpec.ConfigValue<Double> shipGeneralContainerModifier;
        public static ForgeConfigSpec.ConfigValue<Double> shipGeneralPaddlingModifier;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogMaxHealth;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogMaxSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogMaxReverseSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogMaxRotationSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogAcceleration;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeCogRotationAcceleration;
        public static ForgeConfigSpec.ConfigValue<Integer> shipContainerCogContainerSize;
        public static ForgeConfigSpec.ConfigValue<Integer> shipModifierCogBiome;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggMaxHealth;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggMaxSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggMaxReverseSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggMaxRotationSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggAcceleration;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeBriggRotationAcceleration;
        public static ForgeConfigSpec.ConfigValue<Integer> shipContainerBriggContainerSize;
        public static ForgeConfigSpec.ConfigValue<Integer> shipModifierBriggBiome;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyMaxHealth;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyMaxSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyMaxReverseSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyMaxRotationSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyAcceleration;
        public static ForgeConfigSpec.ConfigValue<Double> shipAttributeGalleyRotationAcceleration;
        public static ForgeConfigSpec.ConfigValue<Integer> shipContainerGalleyContainerSize;
        public static ForgeConfigSpec.ConfigValue<Integer> shipModifierGalleyBiome;
        public static ForgeConfigSpec.ConfigValue<Double> waterAnimalFleeRadius;
        public static ForgeConfigSpec.ConfigValue<Double> waterAnimalFleeSpeed;
        public static ForgeConfigSpec.ConfigValue<Double> waterAnimalFleeDistance;
        public static ForgeConfigSpec.BooleanValue smallshipsItemGroupEnable;
    }

    public static class Client {
        public static ForgeConfigSpec.BooleanValue shipGeneralCameraZoomEnable;
        public static ForgeConfigSpec.BooleanValue shipGeneralCameraAutoThirdPerson;
        public static ForgeConfigSpec.ConfigValue<Double> shipGeneralCameraZoomMax;
        public static ForgeConfigSpec.ConfigValue<Double> shipGeneralCameraZoomMin;
    }
}

