/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record AlbumMovePhotoC2SP(int slotIndex, int pageIndex, boolean remove) implements IPacket<AlbumMovePhotoC2SP>
{
    public static final ResourceLocation ID = Exposure.resource("album_move_photo");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    public static AlbumMovePhotoC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new AlbumMovePhotoC2SP(buffer.readInt(), buffer.readInt(), buffer.readBoolean());
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotIndex);
        buffer.writeInt(this.pageIndex);
        buffer.writeBoolean(this.remove);
        return buffer;
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        ItemStack albumStack;
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.m_21205_().m_41720_() instanceof AlbumItem) {
            albumStack = serverPlayer.m_21205_();
        } else if (serverPlayer.m_21206_().m_41720_() instanceof AlbumItem) {
            albumStack = serverPlayer.m_21206_();
        } else {
            throw new IllegalStateException("Cannot handle album packet: Player must have an album in mainhand/offhand");
        }
        AlbumItem album = (AlbumItem)albumStack.m_41720_();
        if (this.remove) {
            ItemStack removedStack = album.setPhotoOnPage(albumStack, ItemStack.f_41583_, this.pageIndex);
            boolean added = player.m_150109_().m_36054_(removedStack);
            if (!added) {
                player.m_7197_(removedStack, true, false);
            }
        } else {
            ItemStack stack = serverPlayer.m_150109_().m_7407_(this.slotIndex, 64);
            album.setPhotoOnPage(albumStack, stack, this.pageIndex);
        }
        return true;
    }
}

