/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AlbumMenu
extends AbstractContainerMenu {
    public static final int MAX_PHOTOGRAPH_SLOTS = 6;
    private final List<AlbumItem.Page> pages;
    private final boolean editing;
    private final DataSlot currentSpreadIndex = DataSlot.m_39401_();
    private final List<DataSlot> photographSlots = new ArrayList<DataSlot>();

    public AlbumMenu(int containerId, Inventory playerInventory, ItemAndStack<AlbumItem> album) {
        super(Exposure.MenuTypes.ALBUM.get(), containerId);
        this.editing = true;
        List<AlbumItem.Page> albumPages = album.getItem().getPages(album.getStack());
        if (this.editing) {
            albumPages = new ArrayList<AlbumItem.Page>(albumPages);
            while (albumPages.size() < 16) {
                albumPages.add(new AlbumItem.Page(ItemStack.f_41583_, Collections.emptyList()));
            }
        }
        this.pages = albumPages;
        for (int i = 0; i < 6; ++i) {
            DataSlot slot = DataSlot.m_39401_();
            slot.m_6422_(-1);
            this.photographSlots.add(slot);
            this.m_38895_(slot);
        }
        this.m_38895_(this.currentSpreadIndex);
    }

    public List<AlbumItem.Page> getPages() {
        return this.pages;
    }

    public int getCurrentSpreadIndex() {
        return this.currentSpreadIndex.m_6501_();
    }

    public void setCurrentSpreadIndex(int index) {
        this.currentSpreadIndex.m_6422_(index);
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_().m_41720_() instanceof AlbumItem || player.m_21206_().m_41720_() instanceof AlbumItem;
    }

    public static AlbumMenu fromBuffer(int containerId, Inventory inventory, FriendlyByteBuf buffer) {
        return new AlbumMenu(containerId, inventory, new ItemAndStack<AlbumItem>(buffer.m_130267_()));
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        super.m_150399_(slotId, button, clickType, player);
    }
}

