/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.client.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackedPhotographsItem
extends Item {
    public static final String PHOTOGRAPHS_TAG = "Photographs";
    private final int maxPhotographs;

    public StackedPhotographsItem(int maxPhotographs, Item.Properties properties) {
        super(properties);
        this.maxPhotographs = maxPhotographs;
    }

    public int getMaxPhotographs() {
        return this.maxPhotographs;
    }

    public int getPhotographsCount(ItemStack stack) {
        return this.getOrCreatePhotographsListTag(stack).size();
    }

    public List<ItemAndStack<PhotographItem>> getPhotographs(ItemStack stack) {
        ListTag listTag = this.getOrCreatePhotographsListTag(stack);
        if (listTag.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>();
        for (int i = 0; i < listTag.size(); ++i) {
            photographs.add(this.getPhotograph(listTag, i));
        }
        return photographs;
    }

    private ListTag getOrCreatePhotographsListTag(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41784_().m_128437_(PHOTOGRAPHS_TAG, 10) : new ListTag();
    }

    public boolean canAddPhotograph(ItemStack stack) {
        return this.getPhotographsCount(stack) < this.getMaxPhotographs();
    }

    public void addPhotograph(ItemStack stack, ItemStack photographStack, int index) {
        Preconditions.checkState((index >= 0 && index <= this.getPhotographsCount(stack) ? 1 : 0) != 0, (Object)(index + " is out of bounds. Count: " + this.getPhotographsCount(stack)));
        Preconditions.checkState((boolean)this.canAddPhotograph(stack), (Object)("Cannot add more photographs than this photo can store. Max count: " + this.getMaxPhotographs()));
        ListTag listTag = this.getOrCreatePhotographsListTag(stack);
        listTag.add(index, (Tag)photographStack.m_41739_(new CompoundTag()));
        stack.m_41784_().m_128365_(PHOTOGRAPHS_TAG, (Tag)listTag);
    }

    public void addPhotographOnTop(ItemStack stack, ItemStack photographStack) {
        this.addPhotograph(stack, photographStack, 0);
    }

    public void addPhotographToBottom(ItemStack stack, ItemStack photographStack) {
        this.addPhotograph(stack, photographStack, this.getPhotographsCount(stack));
    }

    public ItemAndStack<PhotographItem> removePhotograph(ItemStack stack, int index) {
        Preconditions.checkState((index >= 0 && index < this.getPhotographsCount(stack) ? 1 : 0) != 0, (Object)(index + " is out of bounds. Count: " + this.getPhotographsCount(stack)));
        ListTag listTag = this.getOrCreatePhotographsListTag(stack);
        ItemStack photographStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)listTag.remove(index)));
        stack.m_41784_().m_128365_(PHOTOGRAPHS_TAG, (Tag)listTag);
        return new ItemAndStack<PhotographItem>(photographStack);
    }

    public ItemAndStack<PhotographItem> removeTopPhotograph(ItemStack stack) {
        return this.removePhotograph(stack, 0);
    }

    public ItemAndStack<PhotographItem> removeBottomPhotograph(ItemStack stack) {
        return this.removePhotograph(stack, this.getPhotographsCount(stack) - 1);
    }

    private ItemAndStack<PhotographItem> getPhotograph(ListTag photographsList, int index) {
        CompoundTag stackTag = photographsList.m_128728_(index);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)stackTag);
        return new ItemAndStack<PhotographItem>(stack);
    }

    @Nullable
    public Either<String, ResourceLocation> getFirstIdOrTexture(ItemStack stackedPhotographsStack) {
        ListTag listTag = this.getOrCreatePhotographsListTag(stackedPhotographsStack);
        if (listTag.size() == 0) {
            return null;
        }
        CompoundTag first = listTag.m_128728_(0).m_128469_("tag");
        String id = first.m_128461_("Id");
        if (id.length() > 0) {
            return Either.left((Object)id);
        }
        String resource = first.m_128461_("Texture");
        if (resource.length() > 0) {
            return Either.right((Object)new ResourceLocation(resource));
        }
        return null;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(stack);
        if (photographs.size() == 0) {
            return Optional.empty();
        }
        ItemAndStack<PhotographItem> topPhotograph = photographs.get(0);
        return Optional.of(new PhotographTooltip(topPhotograph.getItem().getIdOrTexture(topPhotograph.getStack()), photographs.size()));
    }

    public boolean m_142207_(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY || this.getPhotographsCount(stack) == 0 || !slot.m_5857_(new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        ItemStack slotItem = slot.m_7993_();
        if (slotItem.m_41619_()) {
            ItemAndStack<PhotographItem> photograph = this.removeBottomPhotograph(stack);
            slot.m_5852_(photograph.getStack());
            if (this.getPhotographsCount(stack) == 1) {
                player.f_36096_.m_142503_(this.removeTopPhotograph(stack).getStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (slotItem.m_41720_() instanceof PhotographItem && this.canAddPhotograph(stack)) {
            this.addPhotographToBottom(stack, slotItem);
            slot.m_5852_(ItemStack.f_41583_);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_5857_(new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        if (this.getPhotographsCount(stack) > 0 && other.m_41619_()) {
            ItemAndStack<PhotographItem> photograph = this.removeTopPhotograph(stack);
            access.m_142104_(photograph.getStack());
            if (this.getPhotographsCount(stack) == 1) {
                ItemAndStack<PhotographItem> lastPhotograph = this.removeTopPhotograph(stack);
                slot.m_5852_(lastPhotograph.getStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (other.m_41720_() instanceof PhotographItem) {
            if (this.canAddPhotograph(stack)) {
                this.addPhotographOnTop(stack, other);
                access.m_142104_(ItemStack.f_41583_);
                StackedPhotographsItem.playAddSoundClientside(player);
                return true;
            }
            return false;
        }
        Item lastPhotograph = other.m_41720_();
        if (lastPhotograph instanceof StackedPhotographsItem) {
            StackedPhotographsItem otherStackedItem = (StackedPhotographsItem)lastPhotograph;
            int otherCount = otherStackedItem.getPhotographsCount(other);
            int addedCount = 0;
            for (int i = 0; i < otherCount; ++i) {
                if (!this.canAddPhotograph(stack)) continue;
                ItemAndStack<PhotographItem> photograph = otherStackedItem.removeBottomPhotograph(other);
                this.addPhotographOnTop(stack, photograph.getStack());
                ++addedCount;
            }
            if (otherStackedItem.getPhotographsCount(other) == 0) {
                access.m_142104_(ItemStack.f_41583_);
            } else if (otherStackedItem.getPhotographsCount(other) == 1) {
                access.m_142104_(otherStackedItem.removeTopPhotograph(other).getStack());
            }
            if (addedCount > 0) {
                StackedPhotographsItem.playAddSoundClientside(player);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos resultPos = clickedPos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemInHand = context.m_43722_();
        if (itemInHand.m_41720_() != this || this.getPhotographsCount(itemInHand) == 0) {
            return InteractionResult.FAIL;
        }
        if (player == null || player.m_9236_().m_151570_(resultPos) || !player.m_36204_(resultPos, direction, itemInHand)) {
            return InteractionResult.FAIL;
        }
        if (player.m_36341_()) {
            this.cyclePhotographs(itemInHand, player);
            return InteractionResult.SUCCESS;
        }
        ItemAndStack<PhotographItem> topPhotograph = this.removeTopPhotograph(itemInHand);
        Level level = context.m_43725_();
        PhotographEntity photographEntity = new PhotographEntity(level, resultPos, direction, topPhotograph.getStack().m_41777_());
        if (photographEntity.m_7088_()) {
            if (!level.f_46443_) {
                photographEntity.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, photographEntity.m_20182_());
                level.m_7967_((Entity)photographEntity);
            }
            if (!player.m_7500_()) {
                int photographsCount = this.getPhotographsCount(itemInHand);
                if (photographsCount == 0) {
                    itemInHand.m_41774_(1);
                } else if (photographsCount == 1) {
                    player.m_21008_(context.m_43724_(), this.removeTopPhotograph(itemInHand).getStack());
                }
            } else {
                this.addPhotographOnTop(itemInHand, topPhotograph.getStack());
            }
        } else {
            this.addPhotographOnTop(itemInHand, topPhotograph.getStack());
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (player.m_36341_()) {
            this.cyclePhotographs(itemInHand, player);
            return InteractionResultHolder.m_19090_((Object)itemInHand);
        }
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(itemInHand);
        if (photographs.size() > 0) {
            if (level.f_46443_) {
                ClientGUI.openPhotographScreen(photographs);
                player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
            }
            return InteractionResultHolder.m_19090_((Object)itemInHand);
        }
        return InteractionResultHolder.m_19100_((Object)itemInHand);
    }

    public boolean cyclePhotographs(ItemStack stack, @Nullable Player player) {
        if (this.getPhotographsCount(stack) < 2) {
            return false;
        }
        ItemAndStack<PhotographItem> topPhotograph = this.removeTopPhotograph(stack);
        this.addPhotographToBottom(stack, topPhotograph.getStack());
        if (player != null) {
            player.m_9236_().m_6269_(player, (Entity)player, Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.6f, player.m_9236_().m_213780_().m_188501_() * 0.2f + 1.2f);
            player.m_146850_(GameEvent.f_223697_);
        }
        return true;
    }

    public static void playAddSoundClientside(Player player) {
        if (player.m_9236_().f_46443_) {
            player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, player.m_9236_().m_213780_().m_188501_() * 0.2f + 1.2f);
        }
    }

    public static void playRemoveSoundClientside(Player player) {
        if (player.m_9236_().f_46443_) {
            player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.75f, player.m_9236_().m_213780_().m_188501_() * 0.2f + 0.75f);
        }
    }
}

