/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.item.IFilmItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmRollItem
extends Item
implements IFilmItem {
    public static final String FRAME_SIZE_TAG = "FrameSize";
    private final FilmType filmType;
    private final int defaultFrameSize;
    private final int barColor;

    public FilmRollItem(FilmType filmType, int defaultFrameSize, int barColor, Item.Properties properties) {
        super(properties);
        this.filmType = filmType;
        this.defaultFrameSize = defaultFrameSize;
        this.barColor = barColor;
    }

    @Override
    public FilmType getType() {
        return this.filmType;
    }

    public int getFrameSize(ItemStack filmStack) {
        if (filmStack.m_41783_() != null && filmStack.m_41784_().m_128425_(FRAME_SIZE_TAG, 3)) {
            return Mth.m_14045_((int)filmStack.m_41784_().m_128451_(FRAME_SIZE_TAG), (int)1, (int)2048);
        }
        return this.defaultFrameSize;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getExposedFramesCount(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(1 + 12 * this.getExposedFramesCount(stack) / this.getMaxFrameCount(stack), 13);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.barColor;
    }

    public void addFrame(ItemStack filmStack, CompoundTag frame) {
        ListTag listTag;
        CompoundTag tag = filmStack.m_41784_();
        if (!tag.m_128425_("Frames", 9)) {
            tag.m_128365_("Frames", (Tag)new ListTag());
        }
        if ((listTag = tag.m_128437_("Frames", 10)).size() >= this.getMaxFrameCount(filmStack)) {
            throw new IllegalStateException("Cannot add more frames than film could fit. Size: " + listTag.size());
        }
        listTag.add((Object)frame);
        tag.m_128365_("Frames", (Tag)listTag);
    }

    public boolean canAddFrame(ItemStack filmStack) {
        if (!filmStack.m_41782_() || !filmStack.m_41784_().m_128425_("Frames", 9)) {
            return true;
        }
        return filmStack.m_41784_().m_128437_("Frames", 10).size() < this.getMaxFrameCount(filmStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        int developingStep;
        int frameSize;
        int exposedFrames = this.getExposedFramesCount(stack);
        if (exposedFrames > 0) {
            int totalFrames = this.getMaxFrameCount(stack);
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.frame_count", (Object[])new Object[]{exposedFrames, totalFrames}).m_130940_(ChatFormatting.GRAY));
        }
        if ((frameSize = this.getFrameSize(stack)) != this.defaultFrameSize) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{Component.m_237113_((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).m_130940_(ChatFormatting.GRAY));
        }
        int n = developingStep = stack.m_41783_() != null ? stack.m_41783_().m_128451_("CurrentDevelopingStep") : 0;
        if (((Boolean)Config.Common.CREATE_SPOUT_DEVELOPING_ENABLED.get()).booleanValue() && developingStep > 0) {
            int i;
            List totalSteps = (List)Config.Common.spoutDevelopingSequence(this.getType()).get();
            MutableComponent stepsComponent = Component.m_237113_((String)"");
            for (i = 0; i < developingStep; ++i) {
                stepsComponent.m_7220_((Component)Component.m_237113_((String)"I").m_130940_(ChatFormatting.GOLD));
            }
            for (i = developingStep; i < totalSteps.size(); ++i) {
                stepsComponent.m_7220_((Component)Component.m_237113_((String)"I").m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.film_roll.tooltip.developing_step", (Object[])new Object[]{stepsComponent}).m_130940_(ChatFormatting.GOLD));
        }
        if (exposedFrames > 0 && !PlatformHelper.isModLoaded("jei") && ((Boolean)Config.Client.RECIPE_TOOLTIPS_WITHOUT_JEI.get()).booleanValue()) {
            ClientGUI.addFilmRollDevelopingTooltip(stack, level, tooltipComponents, isAdvanced);
        }
    }
}

