/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AlbumItem
extends Item {
    public static final String PAGES_TAG = "Pages";

    public AlbumItem(Item.Properties properties) {
        super(properties);
    }

    public List<Page> getPages(ItemStack albumStack) {
        CompoundTag tag = albumStack.m_41783_();
        if (tag == null || tag.m_128456_() || !tag.m_128425_(PAGES_TAG, 9)) {
            return Collections.emptyList();
        }
        ListTag pagesList = tag.m_128437_(PAGES_TAG, 10);
        if (pagesList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < pagesList.size(); ++i) {
            pages.add(Page.fromTag(pagesList.m_128728_(i)));
        }
        return pages;
    }

    public ItemStack setPhotoOnPage(ItemStack albumStack, ItemStack photoStack, int pageIndex) {
        Page page;
        CompoundTag tag = albumStack.m_41784_();
        ListTag list = tag.m_128437_(PAGES_TAG, 10);
        ItemStack existingStack = ItemStack.f_41583_;
        if (pageIndex < list.size()) {
            page = Page.fromTag(list.m_128728_(pageIndex));
            existingStack = page.setPhotographStack(photoStack);
        } else {
            page = new Page(photoStack, Collections.emptyList());
            while (list.size() <= pageIndex) {
                list.add((Object)new CompoundTag());
            }
        }
        list.set(pageIndex, (Tag)page.toTag(new CompoundTag()));
        albumStack.m_41784_().m_128365_(PAGES_TAG, (Tag)list);
        return existingStack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openMenu(serverPlayer, itemStack);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    protected void openMenu(ServerPlayer player, final ItemStack albumStack) {
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return albumStack.m_41786_();
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new AlbumMenu(containerId, playerInventory, new ItemAndStack<AlbumItem>(albumStack));
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> buffer.m_130055_(albumStack));
    }

    public static final class Page {
        public static final String PHOTOGRAPH_TAG = "Photo";
        public static final String NOTE_TAG = "Note";
        private ItemStack photographStack;
        private List<Component> note;

        public Page(ItemStack photo, List<Component> note) {
            this.photographStack = photo;
            this.note = note;
        }

        public static Page fromTag(CompoundTag tag) {
            ItemStack photo = tag.m_128425_(PHOTOGRAPH_TAG, 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(PHOTOGRAPH_TAG)) : ItemStack.f_41583_;
            ListTag noteList = tag.m_128437_(NOTE_TAG, 10);
            ArrayList<Component> note = new ArrayList<Component>();
            for (int j = 0; j < noteList.size(); ++j) {
                String noteString = noteList.m_128778_(j);
                note.add(j, (Component)(noteString.isEmpty() ? Component.m_237119_() : Component.Serializer.m_130701_((String)noteString)));
            }
            return new Page(photo, note);
        }

        public CompoundTag toTag(CompoundTag tag) {
            if (!this.photographStack.m_41619_()) {
                tag.m_128365_(PHOTOGRAPH_TAG, (Tag)this.photographStack.m_41739_(new CompoundTag()));
            }
            if (this.note.size() > 0) {
                ListTag noteList = new ListTag();
                for (Component component : this.note) {
                    noteList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component)));
                }
                tag.m_128365_(NOTE_TAG, (Tag)noteList);
            }
            return tag;
        }

        public ItemStack getPhotographStack() {
            return this.photographStack;
        }

        public ItemStack setPhotographStack(ItemStack photographStack) {
            ItemStack existingStack = this.photographStack;
            this.photographStack = photographStack;
            return existingStack;
        }

        public List<Component> getNote() {
            return this.note;
        }

        public void setNote(List<Component> note) {
            this.note = note;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Page that = (Page)obj;
            return Objects.equals(this.photographStack, that.photographStack) && Objects.equals(this.note, that.note);
        }

        public int hashCode() {
            return Objects.hash(this.photographStack, this.note);
        }

        public String toString() {
            return "Page[photo=" + this.photographStack + ", note=" + this.note + "]";
        }
    }
}

