/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureTexture
extends SimpleTexture {
    @Nullable
    private NativeImage image;

    public ExposureTexture(ResourceLocation location) {
        super(location);
    }

    @Nullable
    public static ExposureTexture getTexture(ResourceLocation location) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        @Nullable AbstractTexture existingTexture = (AbstractTexture)textureManager.f_118468_.get(location);
        if (existingTexture != null) {
            ExposureTexture exposureTexture;
            return existingTexture instanceof ExposureTexture ? (exposureTexture = (ExposureTexture)existingTexture) : null;
        }
        try {
            ExposureTexture texture = new ExposureTexture(location);
            textureManager.m_118495_(location, (AbstractTexture)texture);
            return texture;
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot load texture [" + location + "]. " + e);
            return null;
        }
    }

    @Nullable
    public NativeImage getImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            NativeImage image;
            this.image = image = super.m_6335_(Minecraft.m_91087_().m_91098_()).m_118158_();
            return image;
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Cannot load texture: " + e);
            return null;
        }
    }

    public void m_6479_(@NotNull TextureManager pTextureManager, @NotNull ResourceManager pResourceManager, @NotNull ResourceLocation pPath, @NotNull Executor pExecutor) {
        super.m_6479_(pTextureManager, pResourceManager, pPath, pExecutor);
        this.image = null;
    }

    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }
}

