/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.client.render.ExposureTexture;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureImage {
    private final String name;
    @Nullable
    private final ExposureSavedData exposureData;
    @Nullable
    private final ExposureTexture texture;

    public ExposureImage(String name, @NotNull ExposureSavedData exposureData) {
        this.name = name;
        this.exposureData = exposureData;
        this.texture = null;
    }

    public ExposureImage(String name, @NotNull ExposureTexture texture) {
        this.name = name;
        this.exposureData = null;
        this.texture = texture;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        if (this.exposureData != null) {
            return this.exposureData.getWidth();
        }
        if (this.texture != null) {
            @Nullable NativeImage image = this.texture.getImage();
            return image != null ? image.m_84982_() : 1;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }

    public int getHeight() {
        if (this.exposureData != null) {
            return this.exposureData.getHeight();
        }
        if (this.texture != null) {
            @Nullable NativeImage image = this.texture.getImage();
            return image != null ? image.m_85084_() : 1;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }

    public int getPixelABGR(int x, int y) {
        if (this.exposureData != null) {
            return MapColor.m_284315_((int)this.exposureData.getPixel(x, y));
        }
        if (this.texture != null) {
            @Nullable NativeImage image = this.texture.getImage();
            return image != null ? image.m_84985_(x, y) : 0;
        }
        throw new IllegalStateException("Neither exposureData nor texture was specified.");
    }
}

