/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.element;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.gui.screen.IElementWithTooltip;
import io.github.mortuusars.exposure.item.FilmRollItem;
import io.github.mortuusars.exposure.util.CameraInHand;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class FrameCounterButton
extends ImageButton
implements IElementWithTooltip {
    private final int secondaryFontColor = Config.Client.getSecondaryFontColor();
    private final int mainFontColor = Config.Client.getMainFontColor();

    public FrameCounterButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(x, y, width, height, u, v, height, texture, 256, 256, button -> {}, (Component)Component.m_237119_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, pPartialTick);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, pPartialTick);
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        String text = camera.isEmpty() ? "-" : camera.getItem().getFilm(camera.getStack()).map(film -> {
            int exposedFrames = ((FilmRollItem)film.getItem()).getExposedFrames(film.getStack()).size();
            int totalFrames = ((FilmRollItem)film.getItem()).getMaxFrameCount(film.getStack());
            return exposedFrames + "/" + totalFrames;
        }).orElse("-");
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.m_280056_(font, text, this.m_252754_() + xPos, this.m_252907_() + 8, this.secondaryFontColor, false);
        guiGraphics.m_280056_(font, text, this.m_252754_() + xPos, this.m_252907_() + 7, this.mainFontColor, false);
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        components.add(Component.m_237115_((String)"gui.exposure.viewfinder.film_frame_counter.tooltip"));
        CameraInHand camera = CameraInHand.getActive((Player)Minecraft.m_91087_().f_91074_);
        if (!camera.isEmpty() && camera.getItem().getFilm(camera.getStack()).isEmpty()) {
            components.add(Component.m_237115_((String)"gui.exposure.viewfinder.film_frame_counter.tooltip.no_film").m_130948_(Style.f_131099_.m_178520_(14508887)));
        }
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, components, Optional.empty(), mouseX, mouseY);
    }
}

