/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.element;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.client.gui.screen.IElementWithTooltip;
import io.github.mortuusars.exposure.util.Fov;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FocalLengthButton
extends ImageButton
implements IElementWithTooltip {
    private final int secondaryFontColor = Config.Client.getSecondaryFontColor();
    private final int mainFontColor = Config.Client.getMainFontColor();

    public FocalLengthButton(Screen screen, int x, int y, int width, int height, int u, int v, ResourceLocation texture) {
        super(x, y, width, height, u, v, height, texture, 256, 256, button -> {}, (Component)Component.m_237119_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, pPartialTick);
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.exposure.viewfinder.focal_length.tooltip"), mouseX, mouseY);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        int focalLength = (int)Math.round(Fov.fovToFocalLength(ViewfinderClient.getCurrentFov()));
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent text = Component.m_237110_((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{focalLength});
        int textWidth = font.m_92852_((FormattedText)text);
        int xPos = 17 + (29 - textWidth) / 2;
        guiGraphics.m_280614_(font, (Component)text, this.m_252754_() + xPos, this.m_252907_() + 8, this.secondaryFontColor, false);
        guiGraphics.m_280614_(font, (Component)text, this.m_252754_() + xPos, this.m_252907_() + 7, this.mainFontColor, false);
    }
}

