/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.component.FileSaveComponent;
import io.github.mortuusars.exposure.client.gui.screen.Pager;
import io.github.mortuusars.exposure.client.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographScreen
extends ZoomableScreen {
    public static final ResourceLocation WIDGETS_TEXTURE = Exposure.resource("textures/gui/widgets.png");
    private final List<ItemAndStack<PhotographItem>> photographs;
    private final List<String> savedExposures = new ArrayList<String>();
    private final Pager pager = new Pager(WIDGETS_TEXTURE);

    public PhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        super((Component)Component.m_237119_());
        Preconditions.checkState((photographs.size() > 0 ? 1 : 0) != 0, (Object)"No photographs to display.");
        this.photographs = photographs;
        for (ItemAndStack<PhotographItem> photograph : photographs) {
            @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
            if (idOrTexture == null) continue;
            idOrTexture.ifLeft(id -> ExposureClient.getExposureStorage().getOrQuery((String)id));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = (float)this.f_96544_ / 256.0f;
        this.pager.init(this.f_96543_, this.f_96544_, this.photographs.size(), true, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.m_142416_((GuiEventListener)x$0);
        });
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(this.x, this.y, 0.0f);
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
        guiGraphics.m_280168_().m_252880_(-128.0f, -128.0f, 0.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (int i = Math.min(2, this.photographs.size() - 1); i > 0; --i) {
            float posOffset = 4 * i;
            int brightness = Mth.m_14045_((int)(255 - 50 * i), (int)0, (int)255);
            float rotateOffset = 128.0f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(posOffset, posOffset, 0.0f);
            guiGraphics.m_280168_().m_252880_(rotateOffset, rotateOffset, 0.0f);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(i * 90 + 90)));
            guiGraphics.m_280168_().m_252880_(-rotateOffset, -rotateOffset, 0.0f);
            ExposureClient.getExposureRenderer().renderPaperTexture(guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, brightness, brightness, brightness, 255);
            guiGraphics.m_280168_().m_85849_();
        }
        ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPageIndex());
        @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
        if (idOrTexture != null) {
            ExposureClient.getExposureRenderer().renderOnPaper(idOrTexture, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255, false);
        } else {
            ExposureClient.getExposureRenderer().renderPaperTexture(guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, 256.0f, 256.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
        }
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        this.trySaveToFile(photograph, idOrTexture);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Screen.m_96637_() && player != null && player.m_7500_()) {
            ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPageIndex());
            @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
            if (keyCode == 83) {
                if (idOrTexture != null) {
                    idOrTexture.ifLeft(id -> {
                        if (this.savedExposures.contains(id)) {
                            return;
                        }
                        ExposureClient.getExposureStorage().getOrQuery((String)id).ifPresent(exposure -> {
                            this.savedExposures.add((String)id);
                            new Thread(() -> FileSaveComponent.withDefaultFolders(id).save(exposure.getPixels(), exposure.getWidth(), exposure.getHeight(), exposure.getProperties()), "ExposureSaving").start();
                        });
                    });
                }
                return true;
            }
            if (keyCode == 67) {
                if (idOrTexture != null) {
                    String text = (String)idOrTexture.map(id -> id, ResourceLocation::toString);
                    Minecraft.m_91087_().f_91068_.m_90911_(text);
                }
                return true;
            }
            if (keyCode == 80) {
                @Nullable MultiPlayerGameMode gameMode = Minecraft.m_91087_().f_91072_;
                if (idOrTexture != null && gameMode != null) {
                    gameMode.m_105239_(photograph.getStack().m_41777_());
                }
                return true;
            }
        }
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void trySaveToFile(ItemAndStack<PhotographItem> photograph, @Nullable Either<String, ResourceLocation> idOrTexture) {
        if (!((Boolean)Config.Client.EXPOSURE_SAVING.get()).booleanValue() || idOrTexture == null || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        CompoundTag tag = photograph.getStack().m_41783_();
        if (tag == null || !tag.m_128425_("PhotographerId", 11) || !tag.m_128342_("PhotographerId").equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            return;
        }
        idOrTexture.ifLeft(id -> {
            if (this.savedExposures.contains(id)) {
                return;
            }
            ExposureClient.getExposureStorage().getOrQuery((String)id).ifPresent(exposure -> {
                this.savedExposures.add((String)id);
                new Thread(() -> FileSaveComponent.withDefaultFolders(id).save(exposure.getPixels(), exposure.getWidth(), exposure.getHeight(), exposure.getProperties()), "ExposureSaving").start();
            });
        });
    }
}

