/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class Pager {
    public static final int BUTTON_SIZE = 16;
    public long lastChangedAt;
    public int changeCooldownMS = 50;
    public boolean playSound = true;
    protected ResourceLocation texture;
    protected int pages;
    protected boolean cycled;
    protected int currentPage;
    protected ImageButton previousButton;
    protected ImageButton nextButton;

    public Pager(ResourceLocation texture) {
        this.texture = texture;
    }

    public int getCurrentPageIndex() {
        return this.currentPage;
    }

    public void init(int screenWidth, int screenHeight, int pages, boolean cycled, Consumer<AbstractButton> addButtonAction) {
        this.pages = pages;
        this.cycled = cycled;
        this.previousButton = new ImageButton(0, (int)((float)screenHeight / 2.0f - 8.0f), 16, 16, 0, 0, 16, this.texture, button -> this.onPreviousButtonPressed());
        this.nextButton = new ImageButton(screenWidth - 16, (int)((float)screenHeight / 2.0f - 8.0f), 16, 16, 16, 0, 16, this.texture, button -> this.onNextButtonPressed());
        addButtonAction.accept((AbstractButton)this.previousButton);
        addButtonAction.accept((AbstractButton)this.nextButton);
        this.update();
    }

    public void update() {
        this.previousButton.f_93624_ = this.pages > 1 && (this.cycled || this.currentPage > 0);
        this.nextButton.f_93624_ = this.pages > 1 && (this.cycled || this.currentPage < this.pages - 1);
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            this.changePage(PagingDirection.PREVIOUS);
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262) {
            this.changePage(PagingDirection.NEXT);
            return true;
        }
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262 || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            this.lastChangedAt = 0L;
            return true;
        }
        return false;
    }

    protected void onPreviousButtonPressed() {
        this.changePage(PagingDirection.PREVIOUS);
    }

    protected void onNextButtonPressed() {
        this.changePage(PagingDirection.NEXT);
    }

    public void changePage(PagingDirection pagingDirection) {
        if (this.pages < 2 || Util.m_137550_() - this.lastChangedAt < (long)this.changeCooldownMS) {
            return;
        }
        int prevIndex = this.currentPage;
        this.currentPage += pagingDirection == PagingDirection.NEXT ? 1 : -1;
        if (this.cycled && this.currentPage >= this.pages) {
            this.currentPage = 0;
        } else if (this.cycled && this.currentPage < 0) {
            this.currentPage = this.pages - 1;
        } else if (!this.cycled) {
            this.currentPage = Mth.m_14045_((int)this.currentPage, (int)0, (int)(this.pages - 1));
        }
        if (prevIndex != this.currentPage) {
            this.lastChangedAt = Util.m_137550_();
            if (this.playSound) {
                this.playChangeSound();
            }
        }
    }

    protected void playChangeSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)this.getChangeSound(), (float)0.8f, (float)1.0f));
    }

    protected SoundEvent getChangeSound() {
        return Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get();
    }
}

