/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.camera.infrastructure.FrameData;
import io.github.mortuusars.exposure.client.gui.screen.FilmFrameInspectScreen;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomScreen
extends AbstractContainerScreen<LightroomMenu> {
    public static final ResourceLocation MAIN_TEXTURE = Exposure.resource("textures/gui/lightroom.png");
    public static final ResourceLocation FILM_OVERLAYS_TEXTURE = Exposure.resource("textures/gui/lightroom_film_overlays.png");
    public static final int FRAME_SIZE = 54;
    private Button printButton;

    public LightroomScreen(LightroomMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        this.f_97726_ = 176;
        this.f_97727_ = 210;
        super.m_7856_();
        this.f_97731_ = 116;
        this.printButton = new ImageButton(this.f_97735_ + 117, this.f_97736_ + 89, 22, 22, 176, 17, 22, MAIN_TEXTURE, 256, 256, this::onPrintButtonPressed, (Component)Component.m_237119_());
        this.printButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.lightroom.print")));
        this.m_142416_((GuiEventListener)this.printButton);
    }

    private void onPrintButtonPressed(Button button) {
        if (Minecraft.m_91087_().f_91072_ != null) {
            Minecraft.m_91087_().f_91072_.m_105208_(((LightroomMenu)this.m_6262_()).f_38840_, 0);
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.printButton.f_93623_ = this.canPressPrintButton();
        this.printButton.f_93624_ = !((LightroomMenu)this.m_6262_()).isPrinting();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean canPressPrintButton() {
        return ((LightroomMenu)this.m_6262_()).getBlockEntity().canPrint();
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        ListTag frames;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ - 27, this.f_97736_ + 34, 0, 208, 28, 31);
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(0)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ - 21, this.f_97736_ + 41, 238, 0, 18, 18);
        }
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(1)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 7, this.f_97736_ + 91, 238, 18, 18, 18);
        }
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(2)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 41, this.f_97736_ + 91, 238, 36, 18, 18);
        }
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(3)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 59, this.f_97736_ + 91, 238, 54, 18, 18);
        }
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(4)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 77, this.f_97736_ + 91, 238, 72, 18, 18);
        }
        if (!((Slot)((LightroomMenu)this.m_6262_()).f_38839_.get(5)).m_6657_()) {
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 95, this.f_97736_ + 91, 238, 90, 18, 18);
        }
        if (((LightroomMenu)this.m_6262_()).isPrinting()) {
            int progress = ((LightroomMenu)this.m_6262_()).getData().m_6413_(0);
            int time = ((LightroomMenu)this.m_6262_()).getData().m_6413_(1);
            int width = progress != 0 && time != 0 ? progress * 24 / time : 0;
            guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 116, this.f_97736_ + 91, 176, 0, width + 1, 17);
        }
        if ((frames = ((LightroomMenu)this.m_6262_()).getExposedFrames()).size() == 0) {
            guiGraphics.m_280218_(FILM_OVERLAYS_TEXTURE, this.f_97735_ + 4, this.f_97736_ + 15, 0, 136, 168, 68);
            return;
        }
        ItemStack filmStack = ((LightroomMenu)this.m_6262_()).m_38853_(0).m_7993_();
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)item;
        FilmType negative = film.getType();
        int selectedFrame = ((LightroomMenu)this.m_6262_()).getSelectedFrame();
        @Nullable CompoundTag leftFrame = ((LightroomMenu)this.m_6262_()).getFrameIdByIndex(selectedFrame - 1);
        @Nullable CompoundTag centerFrame = ((LightroomMenu)this.m_6262_()).getFrameIdByIndex(selectedFrame);
        @Nullable CompoundTag rightFrame = ((LightroomMenu)this.m_6262_()).getFrameIdByIndex(selectedFrame + 1);
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        guiGraphics.m_280218_(FILM_OVERLAYS_TEXTURE, this.f_97735_ + 1, this.f_97736_ + 15, 0, leftFrame != null ? 68 : 0, 54, 68);
        guiGraphics.m_280218_(FILM_OVERLAYS_TEXTURE, this.f_97735_ + 55, this.f_97736_ + 15, 55, rightFrame != null ? 0 : 68, 64, 68);
        if (rightFrame != null) {
            boolean hasMoreFrames = selectedFrame + 2 < frames.size();
            guiGraphics.m_280218_(FILM_OVERLAYS_TEXTURE, this.f_97735_ + 119, this.f_97736_ + 15, 120, hasMoreFrames ? 68 : 0, 56, 68);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = guiGraphics.m_280168_();
        if (leftFrame != null) {
            this.renderFrame(leftFrame, poseStack, this.f_97735_ + 6, this.f_97736_ + 22, 54.0f, this.isOverLeftFrame(mouseX, mouseY) ? 0.8f : 0.25f, negative);
        }
        if (centerFrame != null) {
            this.renderFrame(centerFrame, poseStack, this.f_97735_ + 61, this.f_97736_ + 22, 54.0f, 0.9f, negative);
        }
        if (rightFrame != null) {
            this.renderFrame(rightFrame, poseStack, this.f_97735_ + 116, this.f_97736_ + 22, 54.0f, this.isOverRightFrame(mouseX, mouseY) ? 0.8f : 0.25f, negative);
        }
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        if (((LightroomMenu)this.m_6262_()).getBlockEntity().isAdvancingFrameOnPrint()) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 800.0f);
            if (selectedFrame < ((LightroomMenu)this.m_6262_()).getTotalFrames() - 1) {
                guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 111, this.f_97736_ + 44, 200, 0, 10, 10);
            } else {
                guiGraphics.m_280218_(MAIN_TEXTURE, this.f_97735_ + 111, this.f_97736_ + 44, 210, 0, 10, 10);
            }
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        boolean advancedTooltips = Minecraft.m_91087_().f_91066_.f_92125_;
        int selectedFrame = ((LightroomMenu)this.m_6262_()).getSelectedFrame();
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        if (this.isOverLeftFrame(mouseX, mouseY)) {
            tooltipLines.add((Component)Component.m_237115_((String)"gui.exposure.lightroom.previous_frame"));
            if (advancedTooltips) {
                this.addFrameInfoToAdvancedTooltip(selectedFrame - 1, tooltipLines);
            }
        } else if (this.isOverCenterFrame(mouseX, mouseY)) {
            tooltipLines.add((Component)Component.m_237110_((String)"gui.exposure.lightroom.current_frame", (Object[])new Object[]{Integer.toString(((LightroomMenu)this.m_6262_()).getSelectedFrame() + 1)}));
            tooltipLines.add((Component)Component.m_237115_((String)"gui.exposure.lightroom.zoom_in.tooltip").m_130940_(ChatFormatting.GRAY));
            if (advancedTooltips) {
                this.addFrameInfoToAdvancedTooltip(selectedFrame, tooltipLines);
            }
        } else if (this.isOverRightFrame(mouseX, mouseY)) {
            tooltipLines.add((Component)Component.m_237115_((String)"gui.exposure.lightroom.next_frame"));
            if (advancedTooltips) {
                this.addFrameInfoToAdvancedTooltip(selectedFrame + 1, tooltipLines);
            }
        }
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltipLines, Optional.empty(), mouseX, mouseY);
    }

    private void addFrameInfoToAdvancedTooltip(int frameIndex, List<Component> tooltipLines) {
        @Nullable CompoundTag frame = ((LightroomMenu)this.m_6262_()).getFrameIdByIndex(frameIndex);
        if (frame != null) {
            Either<String, ResourceLocation> idOrTexture = FrameData.getIdOrTexture(frame);
            MutableComponent component = ((MutableComponent)idOrTexture.map(id -> id.length() > 0 ? Component.m_237113_((String)("Id: " + id)) : Component.m_237119_(), texture -> Component.m_237113_((String)("Texture: " + texture)))).m_130940_(ChatFormatting.DARK_GRAY);
            tooltipLines.add((Component)component);
        }
    }

    private boolean isOverLeftFrame(int mouseX, int mouseY) {
        ListTag frames = ((LightroomMenu)this.m_6262_()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.m_6262_()).getSelectedFrame();
        return selectedFrame - 1 >= 0 && selectedFrame - 1 < frames.size() && this.m_6774_(6, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverCenterFrame(int mouseX, int mouseY) {
        ListTag frames = ((LightroomMenu)this.m_6262_()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.m_6262_()).getSelectedFrame();
        return selectedFrame >= 0 && selectedFrame < frames.size() && this.m_6774_(61, 22, 54, 54, mouseX, mouseY);
    }

    private boolean isOverRightFrame(int mouseX, int mouseY) {
        ListTag frames = ((LightroomMenu)this.m_6262_()).getExposedFrames();
        int selectedFrame = ((LightroomMenu)this.m_6262_()).getSelectedFrame();
        return selectedFrame + 1 >= 0 && selectedFrame + 1 < frames.size() && this.m_6774_(116, 22, 54, 54, mouseX, mouseY);
    }

    public void renderFrame(@Nullable CompoundTag frame, PoseStack poseStack, float x, float y, float size, float alpha, FilmType negative) {
        if (frame == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Either<String, ResourceLocation> idOrTexture = FrameData.getIdOrTexture(frame);
        ExposureClient.getExposureRenderer().render(idOrTexture, true, true, poseStack, (MultiBufferSource)bufferSource, 0.0f, 0.0f, size, size, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, negative.frameR, negative.frameG, negative.frameB, Mth.m_14045_((int)((int)Math.ceil(alpha * 255.0f)), (int)0, (int)255));
        bufferSource.m_109911_();
        poseStack.m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean handled = super.m_7933_(keyCode, scanCode, modifiers);
        if (handled) {
            return true;
        }
        Preconditions.checkState((this.f_96541_ != null ? 1 : 0) != 0);
        Preconditions.checkState((this.f_96541_.f_91072_ != null ? 1 : 0) != 0);
        if (this.f_96541_.f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            this.changeFrame(PagingDirection.PREVIOUS);
            handled = true;
        } else if (this.f_96541_.f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262) {
            this.changeFrame(PagingDirection.NEXT);
            handled = true;
        }
        return handled;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean handled = super.m_6050_(mouseX, mouseY, delta);
        if (!handled && delta >= 0.0 && this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
            this.enterFrameInspectMode();
        }
        return handled;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Preconditions.checkState((this.f_96541_ != null ? 1 : 0) != 0);
            Preconditions.checkState((this.f_96541_.f_91072_ != null ? 1 : 0) != 0);
            if (this.isOverCenterFrame((int)mouseX, (int)mouseY)) {
                this.enterFrameInspectMode();
                return true;
            }
            if (this.isOverLeftFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.PREVIOUS);
                return true;
            }
            if (this.isOverRightFrame((int)mouseX, (int)mouseY)) {
                this.changeFrame(PagingDirection.NEXT);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void changeFrame(PagingDirection navigation) {
        if (navigation == PagingDirection.PREVIOUS && ((LightroomMenu)this.m_6262_()).getSelectedFrame() == 0 || navigation == PagingDirection.NEXT && ((LightroomMenu)this.m_6262_()).getSelectedFrame() == ((LightroomMenu)this.m_6262_()).getTotalFrames() - 1) {
            return;
        }
        Preconditions.checkState((this.f_96541_ != null ? 1 : 0) != 0);
        Preconditions.checkState((this.f_96541_.f_91074_ != null ? 1 : 0) != 0);
        Preconditions.checkState((this.f_96541_.f_91072_ != null ? 1 : 0) != 0);
        int buttonId = navigation == PagingDirection.NEXT ? 2 : 1;
        this.f_96541_.f_91072_.m_105208_(((LightroomMenu)this.m_6262_()).f_38840_, buttonId);
        this.f_96541_.f_91074_.m_5496_(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, this.f_96541_.f_91074_.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f);
        ((LightroomMenu)this.m_6262_()).getBlockEntity().setSelectedFrame(((LightroomMenu)this.m_6262_()).getBlockEntity().getSelectedFrame() + (navigation == PagingDirection.NEXT ? 1 : -1));
    }

    private void enterFrameInspectMode() {
        Minecraft.m_91087_().m_91152_((Screen)new FilmFrameInspectScreen(this, (LightroomMenu)this.m_6262_()));
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_5496_(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, 1.3f);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeft, guiTop, mouseButton) && this.f_97734_ == null;
    }
}

