/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.client.gui.screen.LightroomScreen;
import io.github.mortuusars.exposure.client.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.PagingDirection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmFrameInspectScreen
extends ZoomableScreen {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final ResourceLocation WIDGETS_TEXTURE = Exposure.resource("textures/gui/widgets.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    public static final int BUTTON_SIZE = 16;
    private final LightroomScreen lightroomScreen;
    private final LightroomMenu lightroomMenu;
    private ImageButton previousButton;
    private ImageButton nextButton;

    public FilmFrameInspectScreen(LightroomScreen lightroomScreen, LightroomMenu lightroomMenu) {
        super((Component)Component.m_237119_());
        this.lightroomScreen = lightroomScreen;
        this.lightroomMenu = lightroomMenu;
        this.zoom.minZoom = this.zoom.defaultZoom / (float)Math.pow(this.zoom.step, 2.0);
    }

    public boolean m_7043_() {
        return false;
    }

    private LightroomMenu getLightroomMenu() {
        return this.lightroomMenu;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = (float)this.f_96544_ / 78.0f;
        this.previousButton = new ImageButton(0, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 0, 0, 16, WIDGETS_TEXTURE, this::buttonPressed);
        this.nextButton = new ImageButton(this.f_96543_ - 16, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 16, 0, 16, WIDGETS_TEXTURE, this::buttonPressed);
        this.m_142416_((GuiEventListener)this.previousButton);
        this.m_142416_((GuiEventListener)this.nextButton);
    }

    private void buttonPressed(Button button) {
        if (button == this.previousButton) {
            this.lightroomScreen.changeFrame(PagingDirection.PREVIOUS);
        } else if (button == this.nextButton) {
            this.lightroomScreen.changeFrame(PagingDirection.NEXT);
        }
    }

    public void close() {
        Minecraft.m_91087_().m_91152_((Screen)this.lightroomScreen);
        if (this.minecraft.f_91074_ != null) {
            this.minecraft.f_91074_.m_5496_(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, 0.7f);
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280168_().m_85849_();
        if (this.zoom.targetZoom == this.zoom.minZoom) {
            this.close();
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(this.x, this.y, 0.0f);
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280168_().m_252880_(-39.0f, -39.0f, 0.0f);
        GuiUtil.blit(guiGraphics.m_280168_(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        ItemStack filmStack = this.lightroomMenu.m_38853_(0).m_7993_();
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)item;
        FilmType negative = film.getType();
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        GuiUtil.blit(guiGraphics.m_280168_(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(12.0f, 12.0f, 0.0f);
        int currentFrame = this.getLightroomMenu().getSelectedFrame();
        @Nullable CompoundTag frame = this.getLightroomMenu().getFrameIdByIndex(currentFrame);
        if (frame != null) {
            this.lightroomScreen.renderFrame(frame, guiGraphics.m_280168_(), 0.0f, 0.0f, 54.0f, 1.0f, negative);
        }
        guiGraphics.m_280168_().m_85849_();
        this.previousButton.f_93624_ = currentFrame != 0;
        this.previousButton.f_93623_ = currentFrame != 0;
        this.nextButton.f_93624_ = currentFrame != this.getLightroomMenu().getTotalFrames() - 1;
        this.nextButton.f_93623_ = currentFrame != this.getLightroomMenu().getTotalFrames() - 1;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || this.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.zoom.set(0.0f);
        } else if (this.minecraft.f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            this.lightroomScreen.changeFrame(PagingDirection.PREVIOUS);
        } else if (this.minecraft.f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262) {
            this.lightroomScreen.changeFrame(PagingDirection.NEXT);
        } else {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        if (handled) {
            return true;
        }
        if (button == 1) {
            this.zoom.set(0.0f);
            return true;
        }
        return false;
    }
}

