/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.menu.CameraAttachmentsMenu;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class CameraAttachmentsScreen
extends AbstractContainerScreen<CameraAttachmentsMenu> {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/camera_attachments.png");

    public CameraAttachmentsScreen(CameraAttachmentsMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        this.f_97727_ = 185;
        this.f_97731_ = this.f_97727_ - 94;
        super.m_7856_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Slot flashSlot;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        Slot filmSlot = (Slot)((CameraAttachmentsMenu)this.f_97732_).f_38839_.get(CameraItem.FILM_ATTACHMENT.slot());
        if (!filmSlot.m_6657_()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + filmSlot.f_40220_ - 1, this.f_97736_ + filmSlot.f_40221_ - 1, 238, 0, 18, 18);
        }
        if (!(flashSlot = (Slot)((CameraAttachmentsMenu)this.f_97732_).f_38839_.get(CameraItem.FLASH_ATTACHMENT.slot())).m_6657_()) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + flashSlot.f_40220_ - 1, this.f_97736_ + flashSlot.f_40221_ - 1, 238, 18, 18, 18);
        } else {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 99, this.f_97736_ + 7, 0, 185, 24, 28);
        }
        Slot lensSlot = (Slot)((CameraAttachmentsMenu)this.f_97732_).f_38839_.get(CameraItem.LENS_ATTACHMENT.slot());
        boolean hasLens = lensSlot.m_6657_();
        if (hasLens) {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 103, this.f_97736_ + 49, 24, 185, 31, 35);
        } else {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + lensSlot.f_40220_ - 1, this.f_97736_ + lensSlot.f_40221_ - 1, 238, 36, 18, 18);
        }
        Slot filterSlot = (Slot)((CameraAttachmentsMenu)this.f_97732_).f_38839_.get(CameraItem.FILTER_ATTACHMENT.slot());
        if (filterSlot.m_6657_()) {
            int x = hasLens ? 116 : 106;
            int y = hasLens ? 58 : 53;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)filterSlot.m_7993_().m_41720_());
            if (key.m_135827_().equals("minecraft") && key.m_135815_().contains("_stained_glass_pane")) {
                String colorString = key.m_135815_().replace("_stained_glass_pane", "");
                DyeColor color = DyeColor.m_41057_((String)colorString, (DyeColor)DyeColor.WHITE);
                int rgb = color.m_41070_();
                r = Mth.m_14036_((float)((float)(rgb >> 16 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f);
                g = Mth.m_14036_((float)((float)(rgb >> 8 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f);
                b = Mth.m_14036_((float)((float)(rgb & 0xFF) / 255.0f), (float)0.0f, (float)1.0f);
            }
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            if (!filterSlot.m_7993_().m_150930_(Items.f_42027_)) {
                guiGraphics.m_280218_(TEXTURE, this.f_97735_ + x, this.f_97736_ + y, 55, 185, 15, 23);
            }
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + x, this.f_97736_ + y, 70, 185, 15, 23);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            guiGraphics.m_280218_(TEXTURE, this.f_97735_ + filterSlot.f_40220_ - 1, this.f_97736_ + filterSlot.f_40221_ - 1, 238, 54, 18, 18);
        }
        RenderSystem.disableBlend();
    }

    @NotNull
    protected List<Component> m_280553_(ItemStack stack) {
        List tooltip = super.m_280553_(stack);
        if (stack.m_204117_(Exposure.Tags.Items.LENSES) && this.f_97734_ != null && this.f_97734_.m_7993_().equals(stack)) {
            tooltip.add(Component.m_237110_((String)"gui.exposure.viewfinder.focal_length", (Object[])new Object[]{FocalRange.fromStack(stack).m_7912_()}).m_130940_(ChatFormatting.GOLD));
        }
        return tooltip;
    }
}

