/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.screen.Pager;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumMovePhotoC2SP;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AlbumScreen
extends AbstractContainerScreen<AlbumMenu> {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/album.png");
    public static final int MAIN_FONT_COLOR = 11900788;
    public static final int SECONDARY_FONT_COLOR = 15721674;
    private final Pager pager = new Pager(TEXTURE){

        @Override
        public void init(int screenWidth, int screenHeight, int pages, boolean cycled, Consumer<AbstractButton> addButtonAction) {
            this.pages = pages;
            this.cycled = cycled;
            this.previousButton = new ImageButton(AlbumScreen.this.f_97735_ + 12, AlbumScreen.this.f_97736_ + 164, 13, 15, 407, 0, 15, this.texture, 512, 512, button -> this.onPreviousButtonPressed());
            this.nextButton = new ImageButton(AlbumScreen.this.f_97735_ + 275, AlbumScreen.this.f_97736_ + 164, 13, 15, 420, 0, 15, this.texture, 512, 512, button -> this.onNextButtonPressed());
            this.previousButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.album.previous_page")));
            this.nextButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.album.next_page")));
            addButtonAction.accept((AbstractButton)this.previousButton);
            addButtonAction.accept((AbstractButton)this.nextButton);
            this.update();
        }

        @Override
        protected SoundEvent getChangeSound() {
            return SoundEvents.f_11713_;
        }
    };

    public AlbumScreen(AlbumMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void m_274333_() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)1.0f));
    }

    protected void m_7856_() {
        this.f_97726_ = 299;
        this.f_97727_ = 188;
        super.m_7856_();
        List<AlbumItem.Page> pages = ((AlbumMenu)this.m_6262_()).getPages();
        this.pager.init(this.f_96543_, this.f_96544_, (int)Math.ceil((float)pages.size() / 2.0f), false, x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.f_97729_ = -999;
        this.f_97731_ = -999;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        MultiBufferSource.BufferSource bufferSource;
        Either<String, ResourceLocation> idOrTexture;
        PhotographItem photographItem;
        AlbumItem.Page page;
        ItemStack photoStack;
        Item item;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280398_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 512);
        int currentSpreadIndex = this.pager.getCurrentPageIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        List<AlbumItem.Page> pages = ((AlbumMenu)this.m_6262_()).getPages();
        int leftPage = currentSpreadIndex * 2;
        int rightPage = leftPage + 1;
        if (leftPage < pages.size() && (item = (photoStack = (page = pages.get(leftPage)).getPhotographStack()).m_41720_()) instanceof PhotographItem) {
            photographItem = (PhotographItem)item;
            guiGraphics.m_280398_(TEXTURE, this.f_97735_ + 25, this.f_97736_ + 21, 0, 299.0f, 0.0f, 108, 109, 512, 512);
            idOrTexture = photographItem.getIdOrTexture(photoStack);
            if (idOrTexture != null) {
                bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                ExposureClient.getExposureRenderer().render(idOrTexture, false, false, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, this.f_97735_ + 31, this.f_97736_ + 27, this.f_97735_ + 127, this.f_97736_ + 123, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
                bufferSource.m_109911_();
            }
        }
        if (rightPage < pages.size() && (idOrTexture = (photoStack = (page = pages.get(rightPage)).getPhotographStack()).m_41720_()) instanceof PhotographItem) {
            photographItem = (PhotographItem)idOrTexture;
            guiGraphics.m_280398_(TEXTURE, this.f_97735_ + 166, this.f_97736_ + 21, 0, 299.0f, 0.0f, 108, 109, 512, 512);
            idOrTexture = photographItem.getIdOrTexture(photoStack);
            if (idOrTexture != null) {
                bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                ExposureClient.getExposureRenderer().render(idOrTexture, false, false, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, this.f_97735_ + 172, this.f_97736_ + 27, this.f_97735_ + 268, this.f_97736_ + 123, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, 255, 255, 255, 255);
                bufferSource.m_109911_();
            }
        }
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex) {
        Font font = Minecraft.m_91087_().f_91062_;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.m_280056_(font, leftPageNumber, this.f_97735_ + 71 + (8 - font.m_92895_(leftPageNumber) / 2), this.f_97736_ + 167, 15721674, false);
        guiGraphics.m_280056_(font, rightPageNumber, this.f_97735_ + 212 + (8 - font.m_92895_(rightPageNumber) / 2), this.f_97736_ + 167, 15721674, false);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        List<AlbumItem.Page> pages;
        int currentSpreadIndex;
        int leftPage;
        if (mouseX >= 25.0 && mouseX < 132.0 && mouseY >= 21.0 && mouseY < 128.0 && (leftPage = (currentSpreadIndex = this.pager.getCurrentPageIndex()) * 2) < (pages = ((AlbumMenu)this.m_6262_()).getPages()).size()) {
            ItemStack photographStack = pages.get(leftPage).getPhotographStack();
            if (photographStack.m_41619_()) {
                for (int i = 0; i < 40; ++i) {
                    ItemStack stack = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(i);
                    if (!(stack.m_41720_() instanceof PhotographItem)) continue;
                    Minecraft.m_91087_().f_91074_.m_150109_().m_6836_(i, ItemStack.f_41583_);
                    pages.get(leftPage).setPhotographStack(stack);
                    Packets.sendToServer(new AlbumMovePhotoC2SP(i, leftPage, false));
                    break;
                }
            } else {
                ItemStack removedStack = pages.get(leftPage).setPhotographStack(ItemStack.f_41583_);
                boolean added = Minecraft.m_91087_().f_91074_.m_150109_().m_36054_(removedStack);
                if (!added) {
                    Minecraft.m_91087_().f_91074_.m_7197_(removedStack, true, false);
                }
                pages.get(leftPage).setPhotographStack(ItemStack.f_41583_);
                Packets.sendToServer(new AlbumMovePhotoC2SP(-1, leftPage, true));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }
}

