/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client;

import io.github.mortuusars.exposure.camera.infrastructure.ZoomDirection;
import io.github.mortuusars.exposure.camera.viewfinder.SelfieClient;
import io.github.mortuusars.exposure.camera.viewfinder.ViewfinderClient;
import io.github.mortuusars.exposure.client.gui.ClientGUI;
import io.github.mortuusars.exposure.client.gui.screen.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.util.CameraInHand;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class KeyboardHandler {
    public static boolean handleViewfinderKeyPress(long windowId, int key, int scanCode, int action, int modifiers) {
        Minecraft minecraft = Minecraft.m_91087_();
        @Nullable LocalPlayer player = minecraft.f_91074_;
        if (player == null || !CameraInHand.isActive((Player)player)) {
            return false;
        }
        if (minecraft.f_91066_.f_92103_.m_90832_(key, scanCode)) {
            if (action == 1) {
                return true;
            }
            CameraType currentCameraType = minecraft.f_91066_.m_92176_();
            CameraType newCameraType = currentCameraType == CameraType.FIRST_PERSON ? CameraType.THIRD_PERSON_FRONT : CameraType.FIRST_PERSON;
            minecraft.f_91066_.m_92157_(newCameraType);
            CameraInHand camera = CameraInHand.getActive((Player)player);
            SelfieClient.update(camera.getCamera(), camera.getHand(), true);
            return true;
        }
        if (key == 256 || minecraft.f_91066_.f_92092_.m_90832_(key, scanCode)) {
            if (action == 0) {
                Screen screen = minecraft.f_91080_;
                if (screen instanceof ViewfinderControlsScreen) {
                    ViewfinderControlsScreen viewfinderControlsScreen = (ViewfinderControlsScreen)screen;
                    viewfinderControlsScreen.m_7379_();
                } else {
                    CameraInHand.deactivate((Player)player);
                }
            }
            return true;
        }
        if (!ViewfinderClient.isLookingThrough()) {
            return false;
        }
        if (!(minecraft.f_91080_ instanceof ViewfinderControlsScreen)) {
            if (minecraft.f_91066_.f_92090_.m_90832_(key, scanCode)) {
                ClientGUI.openViewfinderControlsScreen();
                return false;
            }
            if (action == 1 || action == 2) {
                if (key == 334 || key == 61) {
                    ViewfinderClient.zoom(ZoomDirection.IN, false);
                    return true;
                }
                if (key == 333 || key == 45) {
                    ViewfinderClient.zoom(ZoomDirection.OUT, false);
                    return true;
                }
            }
        }
        return false;
    }
}

