/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import io.github.mortuusars.exposure.util.Fov;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitiesInFrame {
    public static List<Entity> get(Player player, double fov, int limit) {
        double currentFov = fov / (double)1.142857f;
        double currentFocalLength = Fov.fovToFocalLength(currentFov);
        List entities = player.m_9236_().m_6249_((Entity)player, new AABB(player.m_20183_()).m_82400_(128.0), entity -> entity instanceof LivingEntity);
        entities.sort((entity, entity2) -> {
            float dist2;
            float dist1 = player.m_20270_(entity);
            if (dist1 == (dist2 = player.m_20270_(entity2))) {
                return 0;
            }
            return dist1 > dist2 ? 1 : -1;
        });
        ArrayList<Entity> entitiesInFrame = new ArrayList<Entity>();
        for (Entity entity3 : entities) {
            double sizeModifier;
            double modifiedDistance;
            if (entitiesInFrame.size() >= limit) break;
            double relativeAngleDegrees = EntitiesInFrame.getRelativeAngle((LivingEntity)player, entity3);
            if (relativeAngleDegrees > currentFov / 2.0) continue;
            double distanceInBlocks = Math.sqrt(player.m_20280_(entity3));
            AABB boundingBox = entity3.m_6921_();
            double size = boundingBox.m_82309_();
            if (Double.isNaN(size) || size == 0.0) {
                size = 0.1;
            }
            if ((modifiedDistance = distanceInBlocks / (sizeModifier = (size - 1.0) * 0.6 + 1.0) / (double)1.142857f) > currentFocalLength || !EntitiesInFrame.hasLineOfSight((LivingEntity)player, entity3)) continue;
            entitiesInFrame.add(entity3);
        }
        return entitiesInFrame;
    }

    public static double getRelativeAngle(LivingEntity origin, Entity target) {
        Vec3 lookAngle = origin.m_20154_();
        Vec3 originEyePos = origin.m_20182_().m_82520_(0.0, (double)origin.m_20192_(), 0.0);
        Vec3 targetEyePos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        Vec3 originToTargetAngle = targetEyePos.m_82546_(originEyePos).m_82541_();
        return Math.toDegrees(Math.acos(lookAngle.m_82526_(originToTargetAngle)));
    }

    public static boolean hasLineOfSight(LivingEntity origin, Entity target) {
        boolean visible = origin.m_142582_(target);
        return visible;
    }
}

