/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.component;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.util.ColorUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class FileSaveComponent
implements ICaptureComponent {
    private final String exposureId;
    private final String folder;
    private final boolean levelNameSubfolder;

    public FileSaveComponent(String exposureId, String folder, boolean levelNameSubfolder) {
        this.exposureId = exposureId;
        this.folder = folder;
        this.levelNameSubfolder = levelNameSubfolder;
    }

    public static FileSaveComponent withDefaultFolders(String exposureId) {
        return new FileSaveComponent(exposureId, "exposures", (Boolean)Config.Client.EXPOSURE_SAVING_LEVEL_SUBFOLDER.get());
    }

    @Override
    public boolean save(byte[] mapColorPixels, int width, int height, CompoundTag properties) {
        BufferedImage img = this.convertToBufferedImage(mapColorPixels, width, height);
        File outputFile = new File(this.folder + "/" + (String)(this.levelNameSubfolder ? this.getLevelName() + "/" : "") + this.exposureId + ".png");
        try {
            outputFile.mkdirs();
            ImageIO.write((RenderedImage)img, "png", outputFile);
            LogUtils.getLogger().info("Exposure saved: " + outputFile);
            return true;
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Exposure file was not saved: " + e);
            return false;
        }
    }

    @NotNull
    private BufferedImage convertToBufferedImage(byte[] MapColorPixels, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int bgr = MapColor.m_284315_((int)MapColorPixels[x + y * width]);
                int rgb = ColorUtils.BGRtoRGB(bgr);
                img.setRGB(x, y, rgb);
            }
        }
        return img;
    }

    private String getLevelName() {
        try {
            if (Minecraft.m_91087_().m_91089_() == null) {
                String gameDirectory = Minecraft.m_91087_().f_91069_.getAbsolutePath();
                Path savesDir = Path.of(gameDirectory, "/saves");
                File[] dirs = savesDir.toFile().listFiles((dir, name) -> new File(dir, name).isDirectory());
                if (dirs == null || dirs.length == 0) {
                    return "";
                }
                File lastModified = dirs[0];
                for (File dir2 : dirs) {
                    if (dir2.lastModified() <= lastModified.lastModified()) continue;
                    lastModified = dir2;
                }
                return lastModified.getName();
            }
            return Minecraft.m_91087_().m_91089_().f_105362_;
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to get level name: " + e);
            return "";
        }
    }
}

