/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ordana.spelunkery.reg.ModRecipes;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrindstonePolishingRecipe
implements Recipe<Container> {
    public static final String NAME = "grindstone_polishing";
    private final ResourceLocation id;
    private final String recipeGroup;
    public final ItemStack ingredient;
    public final ItemStack result;
    private final int resultCount;
    public final ItemStack byproduct;
    private final int byproductMin;
    private final int byproductMax;
    private final int experience;
    private final boolean requiresDiamondGrindstone;

    public GrindstonePolishingRecipe(ResourceLocation id, String recipeGroup, ItemStack ingredient, ItemStack result, int resultCount, ItemStack byproduct, int byproductMin, int byproductMax, int experience, boolean requiresDiamondGrindstone) {
        this.id = id;
        this.recipeGroup = recipeGroup;
        this.ingredient = ingredient;
        this.result = result;
        this.resultCount = resultCount;
        this.byproduct = byproduct;
        this.byproductMin = byproductMin;
        this.byproductMax = byproductMax;
        this.experience = experience;
        this.requiresDiamondGrindstone = requiresDiamondGrindstone;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public boolean isRequiresDiamondGrindstone() {
        return this.requiresDiamondGrindstone;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public int getByproductMin() {
        return this.byproductMin;
    }

    public int getByproductMax() {
        return this.byproductMax;
    }

    public ItemStack getByproduct() {
        return this.byproduct.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return this.recipeGroup;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.GRINDSTONE_POLISHING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.GRINDSTONE_POLISHING.get();
    }

    public static List<GrindstonePolishingRecipe> getRecipes(Level level) {
        return level.m_7465_().m_44013_(ModRecipes.GRINDSTONE_POLISHING.get());
    }

    public static class Serializer
    implements RecipeSerializer<GrindstonePolishingRecipe> {
        public GrindstonePolishingRecipe fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            ItemStack byproduct;
            ItemStack result;
            ItemStack ingredient;
            String group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            if (!jsonObject.has("ingredient")) {
                throw new JsonSyntaxException("Missing ingredient, expected to find a string or object");
            }
            if (jsonObject.get("ingredient").isJsonObject()) {
                ingredient = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient"));
            } else {
                String ingredientItem = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"ingredient");
                ResourceLocation resourcelocation = new ResourceLocation(ingredientItem);
                ingredient = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + ingredientItem + " does not exist")));
            }
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            } else {
                String resultItem = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(resultItem);
                result = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + resultItem + " does not exist")));
            }
            int resultCount = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"resultCount", (int)1);
            if (jsonObject.get("byproduct").isJsonObject()) {
                byproduct = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"byproduct"));
            } else {
                String byproductItem = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"byproduct");
                ResourceLocation resourcelocation = new ResourceLocation(byproductItem);
                byproduct = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + byproductItem + " does not exist")));
            }
            int byproductMin = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"byproductMin", (int)1);
            int byproductMax = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"byproductMax", (int)1);
            int experience = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"experience", (int)0);
            boolean requiresDiamondGrindstone = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"requiresDiamondGrindstone", (boolean)false);
            return new GrindstonePolishingRecipe(pRecipeId, group, ingredient, result, resultCount, byproduct, byproductMin, byproductMax, experience, requiresDiamondGrindstone);
        }

        @Nullable
        public GrindstonePolishingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String group = pBuffer.m_130277_();
            ItemStack ingredient = pBuffer.m_130267_();
            ItemStack result = pBuffer.m_130267_();
            int resultCount = pBuffer.readInt();
            ItemStack byproduct = pBuffer.m_130267_();
            int byproductMin = pBuffer.readInt();
            int byproductMax = pBuffer.readInt();
            int experience = pBuffer.readInt();
            boolean requiresDiamondGrindstone = pBuffer.readBoolean();
            return new GrindstonePolishingRecipe(pRecipeId, group, ingredient, result, resultCount, byproduct, byproductMin, byproductMax, experience, requiresDiamondGrindstone);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, GrindstonePolishingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.recipeGroup);
            pBuffer.m_130055_(pRecipe.ingredient);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.writeInt(pRecipe.resultCount);
            pBuffer.m_130055_(pRecipe.byproduct);
            pBuffer.writeInt(pRecipe.byproductMin);
            pBuffer.writeInt(pRecipe.byproductMax);
            pBuffer.writeInt(pRecipe.experience);
            pBuffer.writeBoolean(pRecipe.requiresDiamondGrindstone);
        }
    }
}

