/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.ordana.spelunkery.blocks.GlowstickBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import com.ordana.spelunkery.reg.ModItems;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MineomiteEntity
extends ImprovedProjectileEntity {
    public MineomiteEntity(EntityType<? extends MineomiteEntity> type, Level world) {
        super(type, world);
    }

    public MineomiteEntity(Level level, LivingEntity thrower) {
        super(ModEntities.MINEOMITE.get(), thrower, level);
    }

    protected Item m_7881_() {
        return ModItems.MINEOMITE.get();
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            SimpleParticleType particle = ParticleTypes.f_175830_;
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)particle, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean canPlace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    public void placeGlowstick(Level level, BlockPos pos, BlockHitResult hitResult) {
        Direction dir = hitResult.m_82434_();
        BlockPos replacePos = pos;
        if (dir == Direction.NORTH || dir == Direction.WEST || dir == Direction.DOWN) {
            replacePos = pos.m_121945_(dir);
        }
        BlockState replaceState = level.m_8055_(replacePos);
        boolean waterlogged = replaceState.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
        if (!MineomiteEntity.canPlace(replaceState)) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)ModItems.MINEOMITE.get())));
        } else if (dir == Direction.NORTH || dir == Direction.WEST || dir == Direction.DOWN) {
            replacePos = pos.m_121945_(dir);
            level.m_46597_(replacePos, (BlockState)((BlockState)ModBlocks.MINEOMITE.get().m_49966_().m_61124_((Property)RodBlock.f_52588_, (Comparable)dir)).m_61124_((Property)GlowstickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        } else {
            level.m_46597_(pos, (BlockState)((BlockState)ModBlocks.MINEOMITE.get().m_49966_().m_61124_((Property)RodBlock.f_52588_, (Comparable)dir)).m_61124_((Property)GlowstickBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        }
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        this.m_6075_();
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.f_150164_ = true;
        }
        Vec3 movement = this.m_20184_();
        double velX = movement.f_82479_;
        double velY = movement.f_82480_;
        double velZ = movement.f_82481_;
        boolean noPhysics = this.isNoPhysics();
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (!(blockstate.m_60795_() || noPhysics || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vector3d1 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vector3d1)) continue;
                this.touchedGround = true;
                break;
            }
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.touchedGround && !noPhysics) {
            ++this.groundTime;
        } else {
            this.groundTime = 0;
            this.m_37283_();
            Vec3 pos = this.m_20182_();
            boolean client = this.f_19853_.f_46443_;
            Vec3 newPos = pos.m_82549_(movement);
            BlockHitResult blockHitResult = this.f_19853_.m_45547_(new ClipContext(pos, newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (blockHitResult.m_6662_() != HitResult.Type.MISS && !noPhysics) {
                newPos = blockHitResult.m_82450_();
                BlockPos newBlockPos = BlockPos.m_274446_((Position)newPos);
                this.placeGlowstick(this.f_19853_, newBlockPos, blockHitResult);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (client) {
                this.spawnTrailParticles(pos, newPos);
            }
            double posX = newPos.f_82479_;
            double posY = newPos.f_82480_;
            double posZ = newPos.f_82481_;
            if (!this.m_20068_() && !noPhysics) {
                this.m_20334_(velX, velY - (double)this.m_7139_(), velZ);
            }
            float deceleration = this.getDeceleration();
            if (this.m_20069_() && client) {
                for (int j = 0; j < 4; ++j) {
                    double pY = posY + (double)this.m_20206_() / 2.0;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, posX - velX * 0.25, pY - velY * 0.25, posZ - velZ * 0.25, velX, velY, velZ);
                }
            }
            this.m_20256_(this.m_20184_().m_82490_((double)deceleration));
            this.m_6034_(posX, posY, posZ);
            this.m_20101_();
            if (!this.m_213877_()) {
                EntityHitResult hitEntity = this.findHitEntity(pos, newPos);
                if (hitEntity != null) {
                    blockHitResult = hitEntity;
                }
                HitResult.Type type = blockHitResult.m_6662_();
                boolean portalHit = false;
                if (type == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)blockHitResult).m_82443_();
                    if (entity instanceof Player) {
                        Player p2;
                        Player p1 = (Player)entity;
                        Entity entity2 = this.m_19749_();
                        if (entity2 instanceof Player && !(p2 = (Player)entity2).m_7099_(p1)) {
                            blockHitResult = null;
                        }
                    }
                } else if (type == HitResult.Type.BLOCK) {
                    BlockPos hitPos = blockHitResult.m_82425_();
                    BlockState hitState = this.f_19853_.m_8055_(hitPos);
                    if (hitState.m_60713_(Blocks.f_50142_)) {
                        this.m_20221_(hitPos);
                        portalHit = true;
                    } else if (hitState.m_60713_(Blocks.f_50446_)) {
                        BlockEntity blockEntity = this.f_19853_.m_7702_(hitPos);
                        if (blockEntity instanceof TheEndGatewayBlockEntity) {
                            TheEndGatewayBlockEntity tile = (TheEndGatewayBlockEntity)blockEntity;
                            if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                                TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)hitPos, (BlockState)hitState, (Entity)this, (TheEndGatewayBlockEntity)tile);
                            }
                        }
                        portalHit = true;
                    }
                }
                if (!(portalHit || blockHitResult == null || type == HitResult.Type.MISS || noPhysics || ForgeHelper.onProjectileImpact((Projectile)this, (HitResult)blockHitResult))) {
                    this.m_6532_((HitResult)blockHitResult);
                    this.f_19812_ = true;
                }
            }
        }
        if (this.hasReachedEndOfLife()) {
            this.reachedEndOfLife();
        }
    }
}

