/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.IExtraBedDataProvider;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PlayerSleepData {
    protected static final String HOME_BED_NBT = "home_bed_id";
    protected static final String INSOMNIA_ELAPSE_NBT = "insomnia_elapses_at";
    protected static final String LAST_TIME_SLEPT_NBT = "last_time_slept";
    protected static final String CONSECUTIVE_NIGHTS_NBT = "consecutive_nights";
    protected static final String HOME_BED_LEVEL_NBT = "home_bed_nights";
    protected static final String USING_DOUBLE_BED_NBT = "using_double_bed";
    @Nullable
    private UUID homeBed = null;
    private long insomniaWillElapseTimeStamp = 0L;
    private long lastWokenUpTimeStamp = -1L;
    private int consecutiveNightsSlept = 0;
    private int nightsSleptInHomeBed = 0;
    private boolean usingDoubleBed = false;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.homeBed != null) {
            tag.m_128362_(HOME_BED_NBT, this.homeBed);
        }
        tag.m_128356_(INSOMNIA_ELAPSE_NBT, this.insomniaWillElapseTimeStamp);
        tag.m_128356_(LAST_TIME_SLEPT_NBT, this.lastWokenUpTimeStamp);
        tag.m_128405_(CONSECUTIVE_NIGHTS_NBT, this.consecutiveNightsSlept);
        tag.m_128405_(HOME_BED_LEVEL_NBT, this.nightsSleptInHomeBed);
        tag.m_128379_(USING_DOUBLE_BED_NBT, this.usingDoubleBed);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(HOME_BED_NBT)) {
            this.homeBed = tag.m_128342_(HOME_BED_NBT);
        }
        this.insomniaWillElapseTimeStamp = tag.m_128454_(INSOMNIA_ELAPSE_NBT);
        this.lastWokenUpTimeStamp = tag.m_128454_(LAST_TIME_SLEPT_NBT);
        this.consecutiveNightsSlept = tag.m_128451_(CONSECUTIVE_NIGHTS_NBT);
        this.nightsSleptInHomeBed = tag.m_128451_(HOME_BED_LEVEL_NBT);
        this.usingDoubleBed = tag.m_128471_(USING_DOUBLE_BED_NBT);
    }

    public void addInsomnia(Player player, long duration) {
        long gameTime = player.m_9236_().m_46467_();
        this.insomniaWillElapseTimeStamp = gameTime + duration;
        this.consecutiveNightsSlept = 0;
        this.lastWokenUpTimeStamp = gameTime;
    }

    public void onNightSleptIntoBed(BedData bed, Player player) {
        long gameTime = player.m_9236_().m_46467_();
        long awakeTime = gameTime - this.lastWokenUpTimeStamp;
        this.consecutiveNightsSlept = awakeTime > (long)CommonConfigs.SLEEP_INTERVAL.get().intValue() ? 0 : ++this.consecutiveNightsSlept;
        this.lastWokenUpTimeStamp = gameTime;
        UUID bedId = bed.getId();
        if (bedId.equals(this.homeBed)) {
            int required = CommonConfigs.HOME_BED_REQUIRED_NIGHTS.get();
            this.nightsSleptInHomeBed = Math.min(required + CommonConfigs.HOME_BED_MAX_LEVEL.get(), this.nightsSleptInHomeBed + 1);
            if (this.nightsSleptInHomeBed >= required) {
                bed.setHomeBedFor(player);
            }
        } else {
            this.homeBed = bedId;
            this.nightsSleptInHomeBed = 0;
        }
    }

    public float getInsomniaCooldown(Player player) {
        if (player.m_150110_().f_35937_) {
            return 0.0f;
        }
        long currentTime = player.m_9236_().m_46467_();
        long timeLeft = this.insomniaWillElapseTimeStamp - currentTime;
        if (timeLeft < 0L) {
            return 0.0f;
        }
        long amountAwake = currentTime - this.lastWokenUpTimeStamp;
        return 1.0f - (float)amountAwake / (float)timeLeft;
    }

    public boolean isOnSleepCooldown(Player player) {
        return this.getInsomniaCooldown(player) > 0.0f;
    }

    public long getInsomniaTimeLeft(Player player) {
        return this.insomniaWillElapseTimeStamp - player.m_9236_().m_46467_();
    }

    public double getNightmareChance(Player player, BlockPos pos) {
        ISleepTightBed bed;
        int minNights = CommonConfigs.NIGHTMARES_CONSECUTIVE_NIGHTS.get();
        if (this.consecutiveNightsSlept < minNights) {
            return 0.0;
        }
        if (DreamEssenceBlock.isInRange(player.m_20183_(), player.m_9236_())) {
            return 0.0;
        }
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ISleepTightBed && !(bed = (ISleepTightBed)block).st_canCauseNightmares()) {
            return 0.0;
        }
        return CommonConfigs.NIGHTMARE_CHANCE_INCREMENT_PER_NIGHT.get() * (double)(this.consecutiveNightsSlept - minNights - 1);
    }

    @Nullable
    public UUID getHomeBed() {
        return this.homeBed;
    }

    public long getInsomniaWillElapseTimeStamp() {
        return this.insomniaWillElapseTimeStamp;
    }

    public int getConsecutiveNightsSlept() {
        return this.consecutiveNightsSlept;
    }

    public int getNightsSleptInHomeBed() {
        return this.nightsSleptInHomeBed;
    }

    public long getLastWokenUpTimeStamp() {
        return this.lastWokenUpTimeStamp;
    }

    public void acceptFromServer(UUID id, long insominaElapse, long sleepTimestamp, int nightSlept, int homeBedNights, boolean doubleBed) {
        this.homeBed = id;
        this.insomniaWillElapseTimeStamp = insominaElapse;
        this.consecutiveNightsSlept = nightSlept;
        this.lastWokenUpTimeStamp = sleepTimestamp;
        this.nightsSleptInHomeBed = homeBedNights;
        this.usingDoubleBed = doubleBed;
    }

    public void syncToClient(ServerPlayer player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage(this));
    }

    public void setConsecutiveNightsSlept(int consecutiveNightsSlept) {
        this.consecutiveNightsSlept = consecutiveNightsSlept;
    }

    public void setNightsSleptInHomeBed(int nightsSleptInHomeBed) {
        this.nightsSleptInHomeBed = nightsSleptInHomeBed;
    }

    public void copyFrom(PlayerSleepData oldData) {
        this.consecutiveNightsSlept = oldData.consecutiveNightsSlept;
        this.homeBed = oldData.homeBed;
        this.nightsSleptInHomeBed = oldData.nightsSleptInHomeBed;
        this.insomniaWillElapseTimeStamp = oldData.insomniaWillElapseTimeStamp;
        this.lastWokenUpTimeStamp = oldData.lastWokenUpTimeStamp;
        this.usingDoubleBed = oldData.usingDoubleBed;
    }

    public int getHomeBedLevel() {
        return Math.max(0, this.nightsSleptInHomeBed - CommonConfigs.HOME_BED_REQUIRED_NIGHTS.get());
    }

    public boolean usingDoubleBed() {
        return this.usingDoubleBed;
    }

    public void setDoubleBed(boolean doubleBed) {
        this.usingDoubleBed = doubleBed;
    }

    @Nullable
    public static BedData getHomeBedIfHere(Player player, BlockPos pos) {
        IExtraBedDataProvider bed;
        BedData bedCap;
        BlockEntity blockEntity;
        PlayerSleepData c = SleepTightPlatformStuff.getPlayerSleepData(player);
        if (c != null && (blockEntity = player.m_9236_().m_7702_(pos)) instanceof IExtraBedDataProvider && (bedCap = (bed = (IExtraBedDataProvider)blockEntity).st_getBedData()).getId().equals(c.getHomeBed()) && bedCap.isHomeBedFor(player)) {
            return bedCap;
        }
        return null;
    }
}

