/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.forge.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.integration.quark.CartographersQuillItem;
import net.mehvahdjukaar.supplementaries.integration.quark.TaterInAJarBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import org.violetmoon.quark.content.building.block.StoolBlock;
import org.violetmoon.quark.content.building.block.WoodPostBlock;
import org.violetmoon.quark.content.building.module.VerticalSlabsModule;
import org.violetmoon.quark.content.client.module.UsesForCursesModule;
import org.violetmoon.quark.content.management.module.ExpandedItemInteractionsModule;
import org.violetmoon.quark.content.tools.module.SlimeInABucketModule;
import org.violetmoon.quark.content.tweaks.module.DoubleDoorOpeningModule;
import org.violetmoon.quark.content.tweaks.module.EnhancedLaddersModule;
import org.violetmoon.quark.content.tweaks.module.MoreBannerLayersModule;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZGatherAdvancementModifiers;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class QuarkCompat {
    public static final String TATER_IN_A_JAR_NAME = "tater_in_a_jar";
    public static final Supplier<Block> TATER_IN_A_JAR = RegUtils.regWithItem("tater_in_a_jar", TaterInAJarBlock::new, new Item.Properties().m_41497_(Rarity.UNCOMMON), 0);
    public static final Supplier<BlockEntityType<TaterInAJarBlock.Tile>> TATER_IN_A_JAR_TILE = RegUtils.regTile("tater_in_a_jar", () -> BlockEntityType.Builder.m_155273_(TaterInAJarBlock.Tile::new, (Block[])new Block[]{TATER_IN_A_JAR.get()}).m_58966_(null));
    public static final Supplier<Item> CARTOGRAPHERS_QUILL = RegUtils.regItem("cartographers_quill", CartographersQuillItem::new);

    public static void init() {
    }

    @PlayEvent
    public static void gatherAdvModifiersEvent(ZGatherAdvancementModifiers event) {
        if (CommonConfigs.Tools.CANDY_ENABLED.get().booleanValue()) {
            event.register(event.createBalancedDietMod(Set.of((ItemLike)ModRegistry.CANDY_ITEM.get())));
        }
        if (CommonConfigs.Functional.SACK_PENALTY.get().booleanValue() && CommonConfigs.Functional.SACK_ENABLED.get().booleanValue()) {
            event.register(event.createFuriousCocktailMod(() -> false, Set.of(ModRegistry.OVERENCUMBERED.get())));
        }
        if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
            event.register(event.createASeedyPlaceMod(Set.of(ModRegistry.FLAX.get())));
        }
    }

    @Nullable
    public static BlockState updateWoodPostShape(BlockState post, Direction facing, BlockState facingState) {
        if (post.m_60734_() instanceof WoodPostBlock) {
            Direction.Axis axis = (Direction.Axis)post.m_61143_((Property)WoodPostBlock.AXIS);
            if (facing.m_122434_() != axis) {
                boolean chain = facingState.m_60734_() instanceof ChainBlock && facingState.m_61143_((Property)BlockStateProperties.f_61365_) == facing.m_122434_();
                return (BlockState)post.m_61124_((Property)WoodPostBlock.CHAINED[facing.ordinal()], (Comparable)Boolean.valueOf(chain));
            }
        }
        return null;
    }

    public static boolean isFastSlideModuleEnabled() {
        return Quark.ZETA.modules.isEnabled(EnhancedLaddersModule.class) && EnhancedLaddersModule.allowSliding;
    }

    public static boolean isDoubleDoorEnabled() {
        return Quark.ZETA.modules.isEnabled(DoubleDoorOpeningModule.class);
    }

    public static boolean canMoveBlockEntity(BlockState state) {
        return !PistonsMoveTileEntitiesModule.shouldMoveTE((boolean)true, (BlockState)state);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEncumbermentFromBackpack(ItemStack stack) {
        return QuarkCompatImpl.getEncumbermentFromBackpack(stack);
    }

    public static boolean isVerticalSlabEnabled() {
        return Quark.ZETA.modules.isEnabled(VerticalSlabsModule.class);
    }

    public static boolean shouldHideOverlay(ItemStack stack) {
        return UsesForCursesModule.staticEnabled && EnchantmentHelper.m_44924_((ItemStack)stack);
    }

    public static int getBannerPatternLimit(int current) {
        return MoreBannerLayersModule.getLimit((int)current);
    }

    public static void tickPiston(Level level, BlockPos pos, BlockState spikes, AABB pistonBB, boolean sameDir, BlockEntity movingTile) {
        List list = level.m_45933_(null, pistonBB);
        for (Entity entity : list) {
            BlockEntity blockEntity;
            AABB entityBB;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.m_6084_() || !pistonBB.m_82381_(entityBB = entity.m_20191_())) continue;
            if (CompatHandler.QUARK && (blockEntity = QuarkCompat.getMovingBlockEntity(pos, spikes, level)) instanceof BambooSpikesBlockTile) {
                IBlockHolder te;
                BlockState state;
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
                if (tile.interactWithEntity(livingEntity, level) && movingTile instanceof IBlockHolder && (state = (te = (IBlockHolder)movingTile).getHeldBlock()).m_60734_() instanceof BambooSpikesBlock) {
                    te.setHeldBlock((BlockState)state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                PistonsMoveTileEntitiesModule.setMovingBlockEntityData((Level)level, (BlockPos)pos, (CompoundTag)tile.m_187480_());
            }
            entity.m_6469_(BambooSpikesBlock.getDamageSource(level), sameDir ? 3.0f : 1.0f);
        }
    }

    public static BlockEntity getMovingBlockEntity(BlockPos pos, BlockState state, Level level) {
        Block block = state.m_60734_();
        if (!(block instanceof EntityBlock)) {
            return null;
        }
        EntityBlock eb = (EntityBlock)block;
        BlockEntity tile = eb.m_142194_(pos, state);
        if (tile == null) {
            return null;
        }
        CompoundTag tileTag = PistonsMoveTileEntitiesModule.getMovingBlockEntityData((Level)level, (BlockPos)pos);
        if (tileTag != null && tile.m_58903_() == BuiltInRegistries.f_257049_.m_7745_(new ResourceLocation(tileTag.m_128461_("id")))) {
            tile.m_142466_(tileTag);
        }
        return tile;
    }

    public static InteractionResult tryCaptureTater(JarItem item, UseOnContext context) {
        ItemStack stack;
        CompoundTag com;
        TinyPotatoBlockEntity te;
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TinyPotatoBlockEntity && (te = (TinyPotatoBlockEntity)blockEntity).m_58903_() != TATER_IN_A_JAR_TILE.get() && ((com = (stack = context.m_43722_()).m_41737_("BlockEntityTag")) == null || com.m_128456_())) {
            if (!world.f_46443_) {
                Player player = context.m_43723_();
                item.playCatchSound(player);
                ItemStack returnItem = new ItemStack((ItemLike)TATER_IN_A_JAR.get());
                if (te.m_8077_()) {
                    returnItem.m_41714_(te.m_7770_());
                }
                Utils.swapItemNBT((Player)player, (InteractionHand)context.m_43724_(), (ItemStack)stack, (ItemStack)returnItem);
                world.m_7471_(pos, false);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static BlockState getMagnetStateForFlintBlock(BlockEntity be, Direction dir) {
        MagnetizedBlockBlockEntity magnet;
        if (be instanceof MagnetizedBlockBlockEntity && dir == (magnet = (MagnetizedBlockBlockEntity)be).getFacing()) {
            return magnet.getMagnetState();
        }
        return null;
    }

    public static ItemStack getSlimeBucket(Entity entity) {
        if (Quark.ZETA.modules.isEnabled(SlimeInABucketModule.class) && entity.m_6095_() == EntityType.f_20526_ && ((Slime)entity).m_33632_() == 1 && entity.m_6084_()) {
            ItemStack outStack = new ItemStack((ItemLike)SlimeInABucketModule.slime_in_a_bucket);
            CompoundTag cmp = new CompoundTag();
            entity.m_20223_(cmp);
            ItemNBTHelper.setCompound((ItemStack)outStack, (String)"slime_nbt", (CompoundTag)cmp);
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isShulkerDropInOn() {
        return Quark.ZETA.modules.isEnabled(ExpandedItemInteractionsModule.class) && ExpandedItemInteractionsModule.enableShulkerBoxInteraction;
    }

    public static boolean tryRotateStool(Level level, BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof StoolBlock) {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)StoolBlock.BIG));
            return true;
        }
        return false;
    }

    public static ItemStack makeAdventurerQuill(ServerLevel serverLevel, @Nullable TagKey<Structure> destination, int radius, boolean skipKnown, int zoom, MapDecoration.Type destinationType, @Nullable String name, int color) {
        HolderSet targets = null;
        if (destination != null) {
            Optional v = serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_203431_(destination);
            if (v.isEmpty()) {
                return ItemStack.f_41583_;
            }
            targets = (HolderSet)v.get();
        }
        return QuarkCompat.makeAdventurerQuill(serverLevel, targets, radius, skipKnown, zoom, destinationType, name, color);
    }

    public static ItemStack makeAdventurerQuill(ServerLevel serverLevel, HolderSet<Structure> targets, int radius, boolean skipKnown, int zoom, MapDecoration.Type destinationType, @Nullable String name, int color) {
        return CartographersQuillItem.forStructure(serverLevel, targets, radius, skipKnown, zoom, destinationType, name, color);
    }

    public static void addItemsToTabs(RegHelper.ItemToTabEvent event) {
    }
}

