/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.backend2.NetworkStuff;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.utils.IOUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.packs.PathPackResources;

public class FiguraRuntimeResources {
    public static final String ASSETS_VERSION = FiguraMod.METADATA.getCustomValueAsString("assets_version");
    public static final PathPackResources PACK = new PathPackResources("Figura runtime resource pack", FiguraRuntimeResources.getRootDirectory(), true);
    private static CompletableFuture<Void> future;

    public static Path getRootDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getCacheDirectory(), "resources");
    }

    public static Path getAssetsDirectory() {
        return IOUtils.getOrCreateDir(FiguraRuntimeResources.getRootDirectory(), "assets/figura");
    }

    public static void clearCache() {
        IOUtils.deleteFile(FiguraRuntimeResources.getRootDirectory());
    }

    public static CompletableFuture<Void> init() {
        future = CompletableFuture.runAsync(() -> {
            JsonObject hashes;
            JsonObject oldHashes;
            FiguraMod.LOGGER.info("Fetching backend resources...");
            Path hashesPath = FiguraRuntimeResources.getRootDirectory().resolve("hashes.json");
            try (BufferedReader reader = Files.newBufferedReader(hashesPath);){
                oldHashes = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception ignored) {
                oldHashes = new JsonObject();
            }
            try (InputStream stream = NetworkStuff.getResourcesHashes(ASSETS_VERSION);){
                byte[] bytes = stream.readAllBytes();
                String s = new String(bytes);
                hashes = JsonParser.parseString((String)s).getAsJsonObject();
                try (OutputStream fs = Files.newOutputStream(hashesPath, new OpenOption[0]);){
                    fs.write(bytes);
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error("Failed to save resource hashes", (Throwable)e);
                }
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to fetch backend resources");
                return;
            }
            for (Map.Entry entry : hashes.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement oldHash = oldHashes.get(key);
                try {
                    if (oldHash != null && oldHash.getAsString().equals(((JsonElement)entry.getValue()).getAsString())) continue;
                    FiguraRuntimeResources.getAndSaveResource(key);
                }
                catch (Exception e) {
                    FiguraMod.debug("Failed to download resource \"" + key + "\"", e);
                }
            }
        });
        return future;
    }

    private static void getAndSaveResource(String path) throws Exception {
        if (((Boolean)Configs.LOCAL_ASSETS.value).booleanValue()) {
            return;
        }
        Path target = FiguraRuntimeResources.getAssetsDirectory().resolve(path);
        IOUtils.createDirIfNeeded(target.getParent());
        try (InputStream resource = NetworkStuff.getResource(ASSETS_VERSION, path);
             OutputStream fs = Files.newOutputStream(target, new OpenOption[0]);){
            fs.write(resource.readAllBytes());
            FiguraMod.debug("Downloaded resource \"" + path + "\"", new Object[0]);
        }
    }

    public static void joinFuture() {
        if (future != null && !future.isDone()) {
            future.join();
        }
    }
}

