/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.permissions;

import forge.org.figuramc.figura.permissions.PermissionManager;
import forge.org.figuramc.figura.permissions.Permissions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public abstract class PermissionPack {
    public String name;
    private boolean visible = true;
    private final Map<Permissions, Integer> permissions = new HashMap<Permissions, Integer>();
    private final Map<String, Map<Permissions, Integer>> customPermissions = new HashMap<String, Map<Permissions, Integer>>();

    public PermissionPack(String name) {
        this.name = name;
    }

    public abstract MutableComponent getCategoryName();

    public abstract int getColor();

    public abstract Permissions.Category getCategory();

    public abstract void setCategory(CategoryPermissionPack var1);

    public void loadNbt(CompoundTag nbt) {
        CompoundTag perms = nbt.m_128469_("permissions");
        for (Permissions setting : Permissions.DEFAULT) {
            if (!perms.m_128441_(setting.name)) continue;
            this.permissions.put(setting, perms.m_128451_(setting.name));
        }
        CompoundTag custom = nbt.m_128469_("custom");
        for (Map.Entry<String, Collection<Permissions>> entry : PermissionManager.CUSTOM_PERMISSIONS.entrySet()) {
            String key = entry.getKey();
            HashMap<Permissions, Integer> map = new HashMap<Permissions, Integer>();
            CompoundTag customNbt = custom.m_128469_(key);
            for (Permissions setting : entry.getValue()) {
                if (!customNbt.m_128441_(setting.name)) continue;
                map.put(setting, customNbt.m_128451_(setting.name));
            }
            this.customPermissions.put(key, map);
        }
    }

    public void writeNbt(CompoundTag nbt) {
        nbt.m_128359_("name", this.name);
        CompoundTag perms = new CompoundTag();
        for (Map.Entry<Permissions, Integer> entry : this.permissions.entrySet()) {
            perms.m_128405_(entry.getKey().name, entry.getValue().intValue());
        }
        nbt.m_128365_("permissions", (Tag)perms);
        CompoundTag custom = new CompoundTag();
        for (Map.Entry<String, Map<Permissions, Integer>> entry : this.customPermissions.entrySet()) {
            CompoundTag customNbt = new CompoundTag();
            for (Map.Entry<Permissions, Integer> entry2 : entry.getValue().entrySet()) {
                customNbt.m_128405_(entry2.getKey().name, entry2.getValue().intValue());
            }
            custom.m_128365_(entry.getKey(), (Tag)customNbt);
        }
        nbt.m_128365_("custom", (Tag)custom);
    }

    public int get(Permissions permissions) {
        Integer setting = this.permissions.get(permissions);
        if (setting != null) {
            return setting;
        }
        for (Map<Permissions, Integer> value : this.customPermissions.values()) {
            setting = value.get(permissions);
            if (setting == null) continue;
            return setting;
        }
        return -1;
    }

    public void insert(Permissions permissions, Integer value, String id) {
        if (Permissions.DEFAULT.contains(permissions)) {
            this.permissions.put(permissions, value);
            return;
        }
        Map map = this.customPermissions.getOrDefault(id, new HashMap());
        map.put(permissions, value);
        this.customPermissions.put(id, map);
    }

    public boolean hasChanges() {
        boolean bool;
        boolean bl = bool = !this.permissions.isEmpty();
        if (!bool) {
            for (Map<Permissions, Integer> value : this.customPermissions.values()) {
                if (value.isEmpty()) continue;
                return true;
            }
        }
        return bool;
    }

    public boolean isChanged(Permissions permissions) {
        if (this.permissions.containsKey(permissions)) {
            return true;
        }
        for (Map<Permissions, Integer> map : this.customPermissions.values()) {
            if (!map.containsKey(permissions)) continue;
            return true;
        }
        return false;
    }

    public void reset(Permissions permissions) {
        this.permissions.remove(permissions);
        for (Map<Permissions, Integer> map : this.customPermissions.values()) {
            map.remove(permissions);
        }
    }

    public void clear() {
        this.permissions.clear();
        this.customPermissions.clear();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Map<Permissions, Integer> getPermissions() {
        return this.permissions;
    }

    public Map<String, Map<Permissions, Integer>> getCustomPermissions() {
        return this.customPermissions;
    }

    public static class PlayerPermissionPack
    extends PermissionPack {
        public CategoryPermissionPack category;

        public PlayerPermissionPack(CategoryPermissionPack category, String name) {
            super(name);
            this.category = category;
        }

        @Override
        public MutableComponent getCategoryName() {
            return this.category.getCategoryName();
        }

        @Override
        public int getColor() {
            return this.category.getColor();
        }

        @Override
        public Permissions.Category getCategory() {
            return this.category.getCategory();
        }

        @Override
        public void setCategory(CategoryPermissionPack newParent) {
            this.category = newParent;
        }

        @Override
        public void writeNbt(CompoundTag nbt) {
            if (this.getCategory() != Permissions.Category.BLOCKED) {
                super.writeNbt(nbt);
            } else {
                nbt.m_128359_("name", this.name);
            }
            nbt.m_128359_("category", this.category.name);
        }

        @Override
        public int get(Permissions permissions) {
            int result = super.get(permissions);
            return result != -1 ? result : this.category.get(permissions);
        }

        @Override
        public boolean isVisible() {
            return this.category.isVisible();
        }
    }

    public static class CategoryPermissionPack
    extends PermissionPack {
        public final Permissions.Category category;

        public CategoryPermissionPack(Permissions.Category category) {
            super(category.name());
            this.category = category;
        }

        @Override
        public MutableComponent getCategoryName() {
            return this.category.text.m_6881_();
        }

        @Override
        public int getColor() {
            return this.category.color;
        }

        @Override
        public Permissions.Category getCategory() {
            return this.category;
        }

        @Override
        public void setCategory(CategoryPermissionPack newParent) {
        }

        @Override
        public int get(Permissions permissions) {
            int result = super.get(permissions);
            return result != -1 ? result : permissions.getDefault(this.getCategory());
        }
    }
}

