/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model.rendering.texture;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public enum RenderTypes {
    NONE(null),
    CUTOUT(RenderType::m_110458_),
    CUTOUT_CULL(RenderType::m_110452_),
    TRANSLUCENT(RenderType::m_110473_),
    TRANSLUCENT_CULL(RenderType::m_110470_),
    EMISSIVE(RenderType::m_110488_),
    EMISSIVE_SOLID(resourceLocation -> RenderType.m_110460_((ResourceLocation)resourceLocation, (boolean)false)),
    EYES(RenderType::m_110488_),
    END_PORTAL(t -> RenderType.m_173239_(), false),
    END_GATEWAY(t -> RenderType.m_173242_(), false),
    TEXTURED_PORTAL(FiguraRenderType.TEXTURED_PORTAL),
    GLINT(t -> RenderType.m_110499_(), false, false),
    GLINT2(t -> RenderType.m_110493_(), false, false),
    TEXTURED_GLINT(FiguraRenderType.TEXTURED_GLINT, true, false),
    LINES(t -> RenderType.m_110504_(), false),
    LINES_STRIP(t -> RenderType.m_173247_(), false),
    SOLID(t -> FiguraRenderType.SOLID, false),
    BLURRY(FiguraRenderType.BLURRY);

    private final Function<ResourceLocation, RenderType> func;
    private final boolean texture;
    private final boolean offset;

    private RenderTypes(Function<ResourceLocation, RenderType> func) {
        this(func, true);
    }

    private RenderTypes(Function<ResourceLocation, RenderType> func, boolean texture) {
        this(func, texture, true);
    }

    private RenderTypes(Function<ResourceLocation, RenderType> func, boolean texture, boolean offset) {
        this.func = func;
        this.texture = texture;
        this.offset = offset;
    }

    public boolean isOffset() {
        return this.offset;
    }

    public RenderType get(ResourceLocation id) {
        if (!this.texture) {
            return this.func.apply(id);
        }
        return id == null || this.func == null ? null : this.func.apply(id);
    }

    private static class FiguraRenderType
    extends RenderType {
        public static final RenderType SOLID = FiguraRenderType.m_173209_((String)"figura_solid", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        public static final Function<ResourceLocation, RenderType> TEXTURED_PORTAL = Util.m_143827_(texture -> FiguraRenderType.m_173215_((String)"figura_textured_portal", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173094_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(texture, false, false).m_173132_(texture, false, false).m_173131_()).m_110691_(false)));
        public static final Function<ResourceLocation, RenderType> BLURRY = Util.m_143827_(texture -> FiguraRenderType.m_173215_((String)"figura_blurry", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, true, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true)));
        public static final Function<ResourceLocation, RenderType> TEXTURED_GLINT = Util.m_143827_(texture -> FiguraRenderType.m_173215_((String)"figura_textured_glint_direct", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173084_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110137_).m_110683_(f_110151_).m_110691_(false)));

        public FiguraRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
        }
    }
}

