/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model.rendering.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.matrix.FiguraMat4;
import forge.org.figuramc.figura.math.vector.FiguraVec2;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.math.vector.FiguraVec4;
import forge.org.figuramc.figura.mixin.render.TextureManagerAccessor;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.LuaUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.lwjgl.BufferUtils;

@LuaWhitelist
@LuaTypeDoc(name="Texture", value="texture")
public class FiguraTexture
extends SimpleTexture {
    private boolean registered = false;
    private boolean dirty = true;
    private boolean modified = false;
    private final String name;
    private final Avatar owner;
    private final NativeImage texture;
    private NativeImage backup;
    private boolean isClosed = false;

    public FiguraTexture(Avatar owner, String name, byte[] data) {
        super((ResourceLocation)new FiguraIdentifier("avatar_tex/" + String.valueOf(owner.owner) + "/" + String.valueOf(UUID.randomUUID())));
        NativeImage image;
        try {
            ByteBuffer wrapper = BufferUtils.createByteBuffer((int)data.length);
            wrapper.put(data);
            wrapper.rewind();
            image = NativeImage.m_85062_((ByteBuffer)wrapper);
        }
        catch (IOException e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
            image = new NativeImage(1, 1, true);
        }
        this.texture = image;
        this.name = name;
        this.owner = owner;
    }

    public FiguraTexture(Avatar owner, String name, int width, int height) {
        super((ResourceLocation)new FiguraIdentifier("avatar_tex/" + String.valueOf(owner.owner) + "/" + String.valueOf(UUID.randomUUID())));
        this.texture = new NativeImage(width, height, true);
        this.name = name;
        this.owner = owner;
    }

    public FiguraTexture(Avatar owner, String name, NativeImage image) {
        super((ResourceLocation)new FiguraIdentifier("avatar_tex/" + String.valueOf(owner.owner) + "/custom/" + String.valueOf(UUID.randomUUID())));
        this.texture = image;
        this.name = name;
        this.owner = owner;
    }

    public void m_6704_(ResourceManager manager) throws IOException {
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.texture.close();
        if (this.backup != null) {
            this.backup.close();
        }
        this.m_117964_();
        ((TextureManagerAccessor)Minecraft.m_91087_().m_91097_()).getByPath().remove(this.f_118129_);
    }

    public void uploadIfDirty() {
        if (!this.registered) {
            Minecraft.m_91087_().m_91097_().m_118495_(this.f_118129_, (AbstractTexture)this);
            this.registered = true;
        }
        if (this.dirty && !this.isClosed) {
            this.dirty = false;
            RenderCall runnable = () -> {
                TextureUtil.prepareImage((int)this.m_117963_(), (int)this.texture.m_84982_(), (int)this.texture.m_85084_());
                this.texture.m_85040_(0, 0, 0, false);
            };
            if (RenderSystem.isOnRenderThreadOrInit()) {
                runnable.m_83909_();
            } else {
                RenderSystem.recordRenderCall((RenderCall)runnable);
            }
        }
    }

    public void writeTexture(Path dest) throws IOException {
        this.texture.m_85066_(dest);
    }

    private void backupImage() {
        this.modified = true;
        if (this.backup == null) {
            this.backup = this.copy();
        }
    }

    public NativeImage copy() {
        NativeImage image = new NativeImage(this.texture.m_85102_(), this.texture.m_84982_(), this.texture.m_85084_(), true);
        image.m_85054_(this.texture);
        return image;
    }

    public int getWidth() {
        return this.texture.m_84982_();
    }

    public int getHeight() {
        return this.texture.m_85084_();
    }

    public ResourceLocation getLocation() {
        return this.f_118129_;
    }

    private FiguraVec4 parseColor(String method, Object r, Double g, Double b, Double a) {
        return LuaUtils.parseVec4(method, r, g, b, a, 0.0, 0.0, 0.0, 1.0);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_name")
    public String getName() {
        return this.name;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_path")
    public String getPath() {
        return this.getLocation().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.get_dimensions")
    public FiguraVec2 getDimensions() {
        return FiguraVec2.of(this.getWidth(), this.getHeight());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"x", "y"})}, value="texture.get_pixel")
    public FiguraVec4 getPixel(int x, int y) {
        try {
            return ColorUtils.abgrToRGBA(this.texture.m_84985_(x, y));
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, FiguraVec3.class}, argumentNames={"x", "y", "rgb"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, FiguraVec4.class}, argumentNames={"x", "y", "rgba"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "r", "g", "b", "a"})}, aliases={"pixel"}, value="texture.set_pixel")
    public FiguraTexture setPixel(int x, int y, Object r, Double g, Double b, Double a) {
        try {
            this.backupImage();
            this.texture.m_84988_(x, y, ColorUtils.rgbaToIntABGR(this.parseColor("setPixel", r, g, b, a)));
            return this;
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    public FiguraTexture pixel(int x, int y, Object r, Double g, Double b, Double a) {
        return this.setPixel(x, y, r, g, b, a);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraVec3.class}, argumentNames={"x", "y", "width", "height", "rgb"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraVec4.class}, argumentNames={"x", "y", "width", "height", "rgba"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"x", "y", "width", "height", "r", "g", "b", "a"})}, value="texture.fill")
    public FiguraTexture fill(int x, int y, int width, int height, Object r, Double g, Double b, Double a) {
        try {
            this.backupImage();
            this.texture.m_84997_(x, y, width, height, ColorUtils.rgbaToIntABGR(this.parseColor("fill", r, g, b, a)));
            return this;
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.update")
    public FiguraTexture update() {
        this.dirty = true;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.restore")
    public FiguraTexture restore() {
        if (this.modified) {
            this.texture.m_85054_(this.backup);
            this.modified = false;
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="texture.save")
    public String save() {
        try {
            return Base64.getEncoder().encodeToString(this.texture.m_85121_());
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, LuaFunction.class}, argumentNames={"x", "y", "width", "height", "func"})}, value="texture.apply_func")
    public FiguraTexture applyFunc(int x, int y, int width, int height, @LuaNotNil LuaFunction function) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                FiguraVec4 color = this.getPixel(j, i);
                LuaValue result = function.call(this.owner.luaRuntime.typeManager.javaToLua(color).arg1(), (LuaValue)LuaValue.valueOf((int)j), (LuaValue)LuaValue.valueOf((int)i));
                if (result.isnil() || !result.isuserdata(FiguraVec4.class)) continue;
                this.setPixel(j, i, result.checkuserdata(FiguraVec4.class), null, null, null);
            }
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class, FiguraMat4.class}, argumentNames={"x", "y", "width", "height", "matrix"})}, value="texture.apply_matrix")
    public FiguraTexture applyMatrix(int x, int y, int width, int height, @LuaNotNil FiguraMat4 matrix) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                FiguraVec4 color = this.getPixel(j, i);
                color.transform(matrix);
                this.setPixel(j, i, color, null, null, null);
            }
        }
        return this;
    }

    @LuaWhitelist
    public Object __index(String arg) {
        return "name".equals(arg) ? this.name : null;
    }

    public String toString() {
        return this.name + " (" + this.getWidth() + "x" + this.getHeight() + ") (Texture)";
    }
}

