/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model.rendering;

import forge.org.figuramc.figura.model.ParentType;

public enum PartFilterScheme {
    MODEL(true, SchemeFunction.cancelOnSeparate(), ParentType.None),
    HEAD(false, SchemeFunction.onlyThis(ParentType.Head), ParentType.Head),
    LEFT_ARM(false, SchemeFunction.onlyThis(ParentType.LeftArm), ParentType.LeftArm),
    RIGHT_ARM(false, SchemeFunction.onlyThis(ParentType.RightArm), ParentType.RightArm),
    CAPE(false, SchemeFunction.onlyThisSeparate(ParentType.Cape), ParentType.Cape),
    LEFT_ELYTRA(false, SchemeFunction.onlyThisSeparate(ParentType.LeftElytra), ParentType.LeftElytra),
    RIGHT_ELYTRA(false, SchemeFunction.onlyThisSeparate(ParentType.RightElytra), ParentType.RightElytra),
    WORLD(false, SchemeFunction.onlyThisSeparate(ParentType.World), ParentType.World),
    HUD(false, SchemeFunction.onlyThisSeparate(ParentType.Hud), ParentType.Hud),
    SKULL(false, SchemeFunction.onlyThisSeparate(ParentType.Skull), ParentType.Skull),
    PORTRAIT(false, SchemeFunction.onlyThisSeparate(ParentType.Portrait), ParentType.Portrait),
    ARROW(false, SchemeFunction.onlyThisSeparate(ParentType.Arrow), ParentType.Arrow),
    ITEM(false, SchemeFunction.onlyThisSeparate(ParentType.Item), ParentType.Item),
    PIVOTS(false, SchemeFunction.onlyPivotsAndCancelOnSeparate(), ParentType.HelmetItemPivot);

    public final boolean initialValue;
    public final SchemeFunction predicate;
    public final ParentType parentType;

    private PartFilterScheme(boolean initialValue, SchemeFunction predicate, ParentType parentType) {
        this.initialValue = initialValue;
        this.predicate = predicate;
        this.parentType = parentType;
    }

    public Boolean test(ParentType toTest, boolean prevResult) {
        return this.predicate.test(toTest, prevResult);
    }

    @FunctionalInterface
    private static interface SchemeFunction {
        public Boolean test(ParentType var1, boolean var2);

        public static SchemeFunction onlyThisSeparate(ParentType typeToAllow) {
            return (parent, prev) -> {
                if (parent == typeToAllow) {
                    return !prev;
                }
                if (parent.isSeparate) {
                    return false;
                }
                return prev;
            };
        }

        public static SchemeFunction cancelOnSeparate() {
            return (parent, prev) -> {
                if (parent.isSeparate) {
                    return null;
                }
                return true;
            };
        }

        public static SchemeFunction onlyThis(ParentType typeToAllow) {
            return (parent, prev) -> {
                if (parent == typeToAllow) {
                    return true;
                }
                if (parent == ParentType.None) {
                    return prev;
                }
                return null;
            };
        }

        public static SchemeFunction onlyPivotsAndCancelOnSeparate() {
            return (parent, prev) -> {
                if (parent.isPivot) {
                    return true;
                }
                if (parent.isSeparate) {
                    return null;
                }
                return false;
            };
        }
    }
}

