/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.render.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.ducks.SkullBlockRendererAccessor;
import forge.org.figuramc.figura.lua.api.entity.EntityAPI;
import forge.org.figuramc.figura.lua.api.world.BlockStateAPI;
import forge.org.figuramc.figura.lua.api.world.ItemStackAPI;
import forge.org.figuramc.figura.permissions.Permissions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkullBlockRenderer.class})
public abstract class SkullBlockRendererMixin
implements BlockEntityRenderer<SkullBlockEntity> {
    @Unique
    private static Avatar avatar;
    @Unique
    private static SkullBlockEntity block;

    @Inject(at={@At(value="HEAD")}, method={"renderSkull"}, cancellable=true)
    private static void renderSkull(Direction direction, float yaw, float animationProgress, PoseStack stack, MultiBufferSource bufferSource, int light, SkullModelBase model, RenderType renderLayer, CallbackInfo ci) {
        SkullBlockEntity localBlock = block;
        block = null;
        ItemStack localItem = SkullBlockRendererAccessor.getItem();
        SkullBlockRendererAccessor.setItem(null);
        Entity localEntity = SkullBlockRendererAccessor.getEntity();
        SkullBlockRendererAccessor.setEntity(null);
        SkullBlockRendererAccessor.SkullRenderMode localMode = SkullBlockRendererAccessor.getRenderMode();
        SkullBlockRendererAccessor.setRenderMode(SkullBlockRendererAccessor.SkullRenderMode.OTHER);
        Avatar localAvatar = avatar;
        avatar = null;
        if (localAvatar == null || localAvatar.permissions.get(Permissions.CUSTOM_SKULL) == 0) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(localAvatar);
        FiguraMod.pushProfiler("skullRender");
        BlockStateAPI b = localBlock == null ? null : new BlockStateAPI(localBlock.m_58900_(), localBlock.m_58899_());
        ItemStackAPI i = localItem != null ? ItemStackAPI.verify(localItem) : null;
        EntityAPI<?> e = localEntity != null ? EntityAPI.wrap(localEntity) : null;
        String m = localMode.name();
        FiguraMod.pushProfiler(localBlock != null ? localBlock.m_58899_().toString() : String.valueOf(i));
        FiguraMod.pushProfiler("event");
        boolean bool = localAvatar.skullRenderEvent(Minecraft.m_91087_().m_91296_(), b, i, e, m);
        FiguraMod.popPushProfiler("render");
        if (bool || localAvatar.skullRender(stack, bufferSource, light, direction, yaw)) {
            ci.cancel();
        }
        FiguraMod.popProfiler(5);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/SkullBlockRenderer;renderSkull(Lnet/minecraft/core/Direction;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/model/SkullModelBase;Lnet/minecraft/client/renderer/RenderType;)V")}, method={"render(Lnet/minecraft/world/level/block/entity/SkullBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"})
    public void render(SkullBlockEntity skullBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, CallbackInfo ci) {
        block = skullBlockEntity;
        SkullBlockRendererAccessor.setRenderMode(SkullBlockRendererAccessor.SkullRenderMode.BLOCK);
    }

    public boolean shouldRenderOffScreen(SkullBlockEntity blockEntity) {
        return avatar == null ? super.m_5932_((BlockEntity)blockEntity) : SkullBlockRendererMixin.avatar.permissions.get(Permissions.OFFSCREEN_RENDERING) == 1;
    }

    @Inject(at={@At(value="HEAD")}, method={"getRenderType"})
    private static void getRenderType(SkullBlock.Type type, GameProfile profile, CallbackInfoReturnable<RenderType> cir) {
        avatar = profile != null && profile.getId() != null ? AvatarManager.getAvatarForPlayer(profile.getId()) : null;
    }
}

