/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.render.layers.elytra;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import forge.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import forge.org.figuramc.figura.permissions.Permissions;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ElytraLayer.class})
public abstract class ElytraLayerMixin<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Shadow
    @Final
    private ElytraModel<T> f_116935_;
    @Unique
    private VanillaPart vanillaPart;

    public ElytraLayerMixin(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/ElytraModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", shift=At.Shift.AFTER)}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void onRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T livingEntity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        this.vanillaPart = null;
        Avatar avatar = AvatarManager.getAvatar(livingEntity);
        if (avatar == null) {
            return;
        }
        if (avatar.luaRuntime != null) {
            VanillaGroupPart part = avatar.luaRuntime.vanilla_model.ELYTRA;
            ((VanillaPart)part).save((EntityModel<?>)this.f_116935_);
            if (avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                this.vanillaPart = part;
                this.vanillaPart.preTransform((EntityModel<?>)this.f_116935_);
            }
        }
        avatar.elytraRender((Entity)livingEntity, multiBufferSource, poseStack, light, tickDelta, (EntityModel<?>)this.f_116935_);
        if (this.vanillaPart != null) {
            this.vanillaPart.posTransform((EntityModel<?>)this.f_116935_);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"})
    public void postRender(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (this.vanillaPart != null) {
            this.vanillaPart.restore((EntityModel<?>)this.f_116935_);
        }
    }
}

