/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.lua.api.world;

import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.api.world.WorldAPI;
import forge.org.figuramc.figura.lua.docs.LuaFieldDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.mixin.BiomeAccessor;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

@LuaWhitelist
@LuaTypeDoc(name="Biome", value="biome")
public class BiomeAPI {
    private final Biome biome;
    private BlockPos pos;
    @LuaWhitelist
    @LuaFieldDoc(value="biome.id")
    public final String id;

    public BiomeAPI(Biome biome, BlockPos pos) {
        this.biome = biome;
        this.pos = pos;
        this.id = ((Registry)WorldAPI.getCurrentWorld().m_9598_().m_6632_(Registries.f_256952_).get()).m_7981_((Object)biome).toString();
    }

    protected BlockPos getBlockPos() {
        return this.pos == null ? BlockPos.f_121853_ : this.pos;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.fromBlockPos(this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="biome.set_pos")
    public BiomeAPI setPos(Object x, Double y, Double z) {
        FiguraVec3 newPos = LuaUtils.parseVec3("setPos", x, y, z);
        this.pos = newPos.asBlockPos();
        return this;
    }

    @LuaWhitelist
    public BiomeAPI pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        Registry registry = WorldAPI.getCurrentWorld().m_9598_().m_175515_(Registries.f_256952_);
        Optional key = registry.m_7854_((Object)this.biome);
        if (key.isEmpty()) {
            return list;
        }
        for (TagKey biomeTagKey : registry.m_246971_((ResourceKey)key.get()).m_203616_().toList()) {
            list.add(biomeTagKey.f_203868_().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_temperature")
    public float getTemperature() {
        return this.biome.m_47554_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_precipitation")
    public String getPrecipitation() {
        return this.biome.m_264600_(this.getBlockPos()).name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_sky_color")
    public FiguraVec3 getSkyColor() {
        return ColorUtils.intToRGB(this.biome.m_47463_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_foliage_color")
    public FiguraVec3 getFoliageColor() {
        return ColorUtils.intToRGB(this.biome.m_47542_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_grass_color")
    public FiguraVec3 getGrassColor() {
        BlockPos pos = this.getBlockPos();
        return ColorUtils.intToRGB(this.biome.m_47464_((double)pos.m_123341_(), (double)pos.m_123342_()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_fog_color")
    public FiguraVec3 getFogColor() {
        return ColorUtils.intToRGB(this.biome.m_47539_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_water_color")
    public FiguraVec3 getWaterColor() {
        return ColorUtils.intToRGB(this.biome.m_47560_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_water_fog_color")
    public FiguraVec3 getWaterFogColor() {
        return ColorUtils.intToRGB(this.biome.m_47561_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.get_downfall")
    public float getDownfall() {
        return ((BiomeAccessor)this.biome).getClimateSettings().f_47683_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.is_hot")
    public boolean isHot() {
        return ((BiomeAccessor)this.biome).getTheTemperature(this.getBlockPos()) > 1.0f;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="biome.is_cold")
    public boolean isCold() {
        return this.biome.m_198904_(this.getBlockPos());
    }

    @LuaWhitelist
    public boolean __eq(BiomeAPI other) {
        return this.biome.equals(other.biome);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        return "id".equals(arg) ? this.id : null;
    }

    public String toString() {
        return this.id + " (Biome)";
    }
}

