/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.lists;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.gui.widgets.FiguraWidget;
import forge.org.figuramc.figura.gui.widgets.SwitchButton;
import forge.org.figuramc.figura.gui.widgets.TextField;
import forge.org.figuramc.figura.gui.widgets.lists.AbstractList;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import forge.org.figuramc.figura.wizards.AvatarWizard;
import forge.org.figuramc.figura.wizards.WizardEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class AvatarWizardList
extends AbstractList {
    private final AvatarWizard wizard;
    private final Map<Component, List<GuiEventListener>> map = new LinkedHashMap<Component, List<GuiEventListener>>();

    public AvatarWizardList(int x, int y, int width, int height, AvatarWizard wizard) {
        super(x, y, width, height);
        this.wizard = wizard;
        this.generate();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 8;
        int entryHeight = 24;
        int size = 0;
        for (List<GuiEventListener> list : this.map.values()) {
            for (GuiEventListener guiEventListener : list) {
                if (guiEventListener instanceof WizardInputBox) {
                    WizardInputBox ib = (WizardInputBox)guiEventListener;
                    ib.setVisible(this.wizard.checkDependency(ib.entry));
                    if (!ib.isVisible()) continue;
                    ++size;
                    continue;
                }
                if (!(guiEventListener instanceof WizardToggleButton)) continue;
                WizardToggleButton tb = (WizardToggleButton)guiEventListener;
                tb.setVisible(this.wizard.checkDependency(tb.entry));
                if (!tb.isVisible()) continue;
                ++size;
            }
        }
        int totalHeight = entryHeight * size + lineHeight * this.map.size();
        this.scrollBar.setVisible(totalHeight > height);
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - height);
        int yOffset = this.scrollBar.isVisible() ? (int)(-Mth.m_14139_((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - height))) : 4;
        for (Map.Entry entry : this.map.entrySet()) {
            List value = (List)entry.getValue();
            if (value.isEmpty()) continue;
            int newY = yOffset + lineHeight;
            for (GuiEventListener w : (List)entry.getValue()) {
                FiguraWidget widget = (FiguraWidget)w;
                if (!widget.isVisible()) continue;
                widget.m_253211_(y + newY);
                newY += entryHeight;
            }
            if (newY == yOffset + lineHeight) continue;
            gui.m_280653_(font, (Component)entry.getKey(), x + width / 2, y + yOffset + 4, 0xFFFFFF);
            yOffset = newY;
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
        gui.m_280618_();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof TextField)) continue;
            TextField field = (TextField)guiEventListener;
            field.getField().m_93692_(field.isEnabled() && field.m_5953_(mouseX, mouseY));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void generate() {
        for (List<GuiEventListener> value : this.map.values()) {
            this.children.removeAll(value);
        }
        this.map.clear();
        int x = this.m_252754_() + this.m_5711_() / 2 + 4;
        int width = this.m_5711_() / 2 - 20;
        MutableComponent lastName = Component.m_237119_();
        ArrayList<FiguraWidget> lastList = new ArrayList<FiguraWidget>();
        for (WizardEntry value : WizardEntry.all()) {
            switch (value.type) {
                case CATEGORY: {
                    if (!lastList.isEmpty()) {
                        this.map.put((Component)lastName, lastList);
                        this.children.addAll(lastList);
                    }
                    lastName = FiguraText.of("gui.avatar_wizard." + value.name.toLowerCase());
                    lastList = new ArrayList();
                    break;
                }
                case TEXT: {
                    lastList.add(new WizardInputBox(x, width, this, value));
                    break;
                }
                case TOGGLE: {
                    lastList.add(new WizardToggleButton(x, width, this, value));
                }
            }
        }
        this.map.put((Component)lastName, lastList);
        this.children.addAll(lastList);
    }

    private static class WizardInputBox
    extends TextField {
        private final AvatarWizardList parent;
        private final WizardEntry entry;
        private final Component name;

        public WizardInputBox(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, TextField.HintType.ANY, s -> parent.wizard.changeEntry(entry, s));
            this.parent = parent;
            this.entry = entry;
            this.name = FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase());
            this.getField().m_94144_(String.valueOf(parent.wizard.getEntry(entry, "")));
        }

        @Override
        public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            super.m_88315_(gui, mouseX, mouseY, delta);
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent name = this.name.m_6881_();
            if (!this.getField().m_94155_().isBlank()) {
                name.m_6270_(FiguraMod.getAccentColor());
            }
            int n = this.m_252754_() - this.m_5711_() - 8;
            float f = this.m_252907_();
            int n2 = this.m_93694_();
            Objects.requireNonNull(font);
            gui.m_280430_(font, (Component)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }

    private static class WizardToggleButton
    extends SwitchButton {
        private final AvatarWizardList parent;
        private final WizardEntry entry;

        public WizardToggleButton(int x, int width, AvatarWizardList parent, WizardEntry entry) {
            super(x, 0, width, 20, (Component)FiguraText.of("gui.avatar_wizard." + entry.name.toLowerCase()), false);
            this.parent = parent;
            this.entry = entry;
            this.setToggled((Boolean)parent.wizard.getEntry(entry, false));
        }

        @Override
        public void m_5691_() {
            super.m_5691_();
            this.parent.wizard.changeEntry(this.entry, this.isToggled());
        }

        @Override
        protected void renderDefaultTexture(GuiGraphics gui, float delta) {
            PoseStack pose = gui.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(this.m_5711_() - 30), 0.0f, 0.0f);
            super.renderDefaultTexture(gui, delta);
            pose.m_85849_();
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent name = this.m_6035_().m_6881_();
            if (this.isToggled()) {
                name.m_130948_(FiguraMod.getAccentColor());
            }
            int n = this.m_252754_() - this.m_5711_() - 8;
            float f = this.m_252907_();
            int n2 = this.m_93694_();
            Objects.requireNonNull(font);
            gui.m_280430_(font, (Component)name, n, (int)(f + (float)(n2 - 9) / 2.0f), 0xFFFFFF);
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }
}

