/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.config;

import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.config.ConfigType;
import forge.org.figuramc.figura.gui.widgets.ContextMenu;
import forge.org.figuramc.figura.gui.widgets.ParentedButton;
import forge.org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import forge.org.figuramc.figura.gui.widgets.config.CategoryWidget;
import forge.org.figuramc.figura.gui.widgets.lists.ConfigList;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EnumElement
extends AbstractConfigElement {
    private final List<Component> names;
    private final ParentedButton button;
    private ContextMenu context;

    public EnumElement(int width, ConfigType.EnumConfig config, ConfigList parentList, CategoryWidget parentCategory) {
        super(width, config, parentList, parentCategory);
        this.names = config.enumList;
        int selectedIndex = (Integer)this.config.tempValue % this.names.size();
        this.button = new ParentedButton(0, 0, 90, 20, this.names.get(selectedIndex), this, button -> {
            this.context.setVisible(!this.context.isVisible());
            if (this.context.isVisible()) {
                this.updateContextText();
                UIHelper.setContext(this.context);
            }
        }){

            @Override
            protected void renderText(GuiGraphics gui, float delta) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component arrow = EnumElement.this.context.isVisible() ? UIHelper.DOWN_ARROW : UIHelper.UP_ARROW;
                int arrowWidth = font.m_92852_((FormattedText)arrow);
                Component message = this.m_6035_();
                int textWidth = font.m_92852_((FormattedText)message);
                int color = this.getTextColor();
                UIHelper.renderCenteredScrollingText(gui, message, this.m_252754_() + 1, this.m_252907_(), this.m_5711_() - (textWidth <= this.m_5711_() - arrowWidth - 9 ? 0 : arrowWidth + 1) - 2, this.m_93694_(), color);
                int n = this.m_252754_() + this.m_5711_() - arrowWidth - 3;
                float f = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
                Objects.requireNonNull(font);
                gui.m_280430_(font, arrow, n, (int)(f - 9.0f / 2.0f), color);
            }

            @Override
            public void setHovered(boolean hovered) {
                if (!hovered && UIHelper.getContext() == EnumElement.this.context && EnumElement.this.context.isVisible()) {
                    hovered = true;
                }
                super.setHovered(hovered);
            }
        };
        this.children.add(0, this.button);
        this.button.setActive(FiguraMod.debugModeEnabled() || !config.disabled);
        if (config.enumTooltip != null) {
            this.button.setTooltip(config.enumTooltip.get(selectedIndex));
        }
        this.context = new ContextMenu((GuiEventListener)this.button, this.button.m_5711_());
        for (int i = 0; i < this.names.size(); ++i) {
            int finalI = i;
            Component tooltip = config.enumTooltip != null ? config.enumTooltip.get(i) : null;
            this.context.addAction(this.names.get(i), tooltip, button1 -> {
                config.tempValue = finalI;
            });
        }
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.resetButton.setActive(!this.isDefault());
        int selectedIndex = (Integer)this.config.tempValue % this.names.size();
        Component text = this.names.get(selectedIndex);
        if (this.isChanged()) {
            text = text.m_6881_().m_6270_(FiguraMod.getAccentColor());
        }
        this.button.m_93666_(text);
        List<Component> tooltip = ((ConfigType.EnumConfig)this.config).enumTooltip;
        if (tooltip != null) {
            this.button.setTooltip(tooltip.get(selectedIndex));
        }
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.button.m_252865_(x + this.m_5711_() - 154);
        this.context.m_252865_(this.button.m_252754_() + this.button.m_5711_() / 2 - this.context.m_5711_() / 2);
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.button.m_253211_(y);
        this.context.m_253211_(this.button.m_252907_() + 20);
    }

    private void updateContextText() {
        List<? extends AbstractWidget> entries = this.context.getEntries();
        for (int i = 0; i < this.names.size(); ++i) {
            Component text = this.names.get(i);
            if (i == (Integer)this.config.tempValue % this.names.size()) {
                text = Component.m_237119_().m_6270_(FiguraMod.getAccentColor()).m_130940_(ChatFormatting.UNDERLINE).m_7220_(text);
            }
            entries.get(i).m_93666_(text);
        }
    }
}

