/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import forge.org.figuramc.figura.gui.widgets.FiguraWidget;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.MathUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollBarWidget
extends AbstractWidget
implements FiguraWidget {
    public static final ResourceLocation SCROLLBAR_TEXTURE = new FiguraIdentifier("textures/gui/scrollbar.png");
    protected final int headHeight = 20;
    protected final int headWidth = 10;
    protected boolean isScrolling = false;
    protected boolean vertical = true;
    protected double scrollPos;
    protected double scrollPrecise;
    protected double scrollRatio = 1.0;
    protected OnPress onPress;

    public ScrollBarWidget(int x, int y, int width, int height, double initialValue) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.scrollPrecise = initialValue;
        this.scrollPos = initialValue;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(this.m_142518_() && this.m_198029_() && this.m_5953_(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            double scrollPos = Mth.m_14139_((double)this.scrollPrecise, (double)0.0, (double)((double)(this.vertical ? this.m_93694_() - 20 : this.m_5711_() - 10) + 2.0));
            if (this.vertical && mouseY < (double)this.m_252907_() + scrollPos || mouseY > (double)this.m_252907_() + scrollPos + 20.0) {
                this.scroll(-((double)this.m_252907_() + scrollPos + 10.0 - mouseY));
            } else if (!this.vertical && mouseX < (double)this.m_252754_() + scrollPos || mouseX > (double)this.m_252754_() + scrollPos + 10.0) {
                this.scroll(-((double)this.m_252754_() + scrollPos + 5.0 - mouseX));
            }
            this.isScrolling = true;
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            if (this.vertical) {
                if (Math.signum(deltaY) == -1.0) {
                    if (mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
                        this.scroll(deltaY);
                        return true;
                    }
                } else if (mouseY >= (double)this.m_252907_()) {
                    this.scroll(deltaY);
                    return true;
                }
            } else if (Math.signum(deltaX) == -1.0) {
                if (mouseX <= (double)(this.m_252754_() + this.m_5711_())) {
                    this.scroll(deltaX);
                    return true;
                }
            } else if (mouseX >= (double)this.m_252754_()) {
                this.scroll(deltaX);
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.m_142518_()) {
            return false;
        }
        this.scroll(-amount * (double)(this.vertical ? this.m_93694_() : this.m_5711_()) * 0.05 * this.scrollRatio);
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_142518_()) {
            return false;
        }
        if (keyCode > 261 && keyCode < 266) {
            this.scroll((double)((keyCode % 2 == 0 ? 1 : -1) * (this.vertical ? this.m_93694_() : this.m_5711_())) * 0.05 * this.scrollRatio);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mouseX, mouseY);
    }

    protected void scroll(double amount) {
        this.scrollPrecise += amount / ((double)(this.vertical ? this.m_93694_() - 20 : this.m_5711_() - 10) + 2.0);
        this.setScrollProgress(this.scrollPrecise);
    }

    protected void lerpPos(float delta) {
        float lerpDelta = MathUtils.magicDelta(0.2f, delta);
        this.scrollPos = Mth.m_14139_((double)lerpDelta, (double)this.scrollPos, (double)this.getScrollProgress());
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.f_93622_ = this.m_5953_(mouseX, mouseY);
        this.m_87963_(gui, mouseX, mouseY, delta);
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        UIHelper.enableBlend();
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        gui.m_280411_(SCROLLBAR_TEXTURE, x, y, width, 1, 10.0f, this.isScrolling ? 20.0f : 0.0f, 10, 1, 20, 40);
        gui.m_280411_(SCROLLBAR_TEXTURE, x, y + 1, width, height - 2, 10.0f, this.isScrolling ? 21.0f : 1.0f, 10, 18, 20, 40);
        gui.m_280411_(SCROLLBAR_TEXTURE, x, y + height - 1, width, 1, 10.0f, this.isScrolling ? 39.0f : 19.0f, 10, 1, 20, 40);
        this.lerpPos(delta);
        gui.m_280163_(SCROLLBAR_TEXTURE, x, (int)((long)y + Math.round(Mth.m_14139_((double)this.scrollPos, (double)0.0, (double)(height - 20)))), 0.0f, this.m_198029_() || this.isScrolling ? 20.0f : 0.0f, 10, 20, 20, 40);
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    @Override
    public boolean isVisible() {
        return this.f_93624_;
    }

    @Override
    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    @Override
    public int m_252754_() {
        return super.m_252754_();
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
    }

    @Override
    public int m_252907_() {
        return super.m_252907_();
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
    }

    @Override
    public int m_5711_() {
        return super.m_5711_();
    }

    @Override
    public void m_93674_(int width) {
        super.m_93674_(width);
    }

    @Override
    public int m_93694_() {
        return super.m_93694_();
    }

    @Override
    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public boolean m_142518_() {
        return this.f_93623_;
    }

    public void setActive(boolean active) {
        this.f_93623_ = active;
    }

    public double getScrollProgress() {
        return this.scrollPrecise;
    }

    public void setScrollProgress(double amount) {
        this.setScrollProgress(amount, false);
    }

    public void setScrollProgressNoAnim(double amount) {
        this.setScrollProgress(amount, false);
        this.scrollPos = this.scrollPrecise;
    }

    public void setScrollProgress(double amount, boolean force) {
        amount = Double.isNaN(amount) ? 0.0 : amount;
        double d = this.scrollPrecise = force ? amount : Mth.m_14008_((double)amount, (double)0.0, (double)1.0);
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    public void setAction(OnPress onPress) {
        this.onPress = onPress;
    }

    public void setScrollRatio(double entryHeight, double heightDiff) {
        this.scrollRatio = ((double)this.m_93694_() + entryHeight) / (heightDiff / 2.0);
    }

    public static interface OnPress {
        public void onPress(ScrollBarWidget var1);
    }
}

