/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.gui.screens.AvatarScreen;
import forge.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import forge.org.figuramc.figura.gui.widgets.SwitchButton;
import forge.org.figuramc.figura.model.rendering.EntityRenderMode;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class EntityPreview
extends AbstractContainerElement {
    public static final ResourceLocation UNKNOWN = new FiguraIdentifier("textures/gui/unknown_entity.png");
    public static final ResourceLocation OVERLAY = new FiguraIdentifier("textures/gui/entity_overlay.png");
    private LivingEntity entity;
    private final float pitch;
    private final float yaw;
    private final float scale;
    private SwitchButton button;
    private boolean isRotating = false;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private float anchorAngleX = 0.0f;
    private float anchorAngleY = 0.0f;
    private float angleX;
    private float angleY;
    private float scaledValue = 0.0f;
    private float scaledPrecise = 0.0f;
    private static final float SCALE_FACTOR = 1.1f;
    private boolean isDragging = false;
    private int modelX;
    private int modelY;
    private float dragDeltaX;
    private float dragDeltaY;
    private float dragAnchorX;
    private float dragAnchorY;

    public EntityPreview(int x, int y, int width, int height, float scale, float pitch, float yaw, LivingEntity entity, Screen parentScreen) {
        super(x, y, width, height);
        this.scale = scale;
        this.pitch = pitch;
        this.yaw = yaw;
        this.entity = entity;
        this.modelX = width / 2;
        this.modelY = height / 2;
        this.angleX = pitch;
        this.angleY = yaw;
        this.button = new SwitchButton(x + 4, y + 4, 16, 16, 0, 0, 16, new FiguraIdentifier("textures/gui/expand.png"), 48, 32, (Component)FiguraText.of("gui.expand"), bx -> {
            if (this.button.isToggled()) {
                Minecraft.m_91087_().m_91152_((Screen)new AvatarScreen(scale, pitch, yaw, this.entity, parentScreen));
            } else {
                Minecraft.m_91087_().m_91152_(parentScreen);
            }
        });
        this.children.add(this.button);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        int x = this.m_252754_();
        int y = this.m_252907_();
        int width = this.m_5711_();
        int height = this.m_93694_();
        if (!this.button.isToggled()) {
            UIHelper.blitSliced(gui, x, y, width, height, UIHelper.OUTLINE_FILL);
            UIHelper.blit(gui, x + 1, y + 1, width - 2, height, OVERLAY);
        }
        gui.m_280588_(x + 1, y + 1, x + width - 1, y + height - 1);
        PoseStack pose = gui.m_280168_();
        if (this.entity != null) {
            pose.m_85836_();
            this.scaledValue = Mth.m_14179_((float)((float)(1.0 - Math.pow(0.5, delta))), (float)this.scaledValue, (float)this.scaledPrecise);
            UIHelper.drawEntity(x + this.modelX, y + this.modelY, this.scale + this.scaledValue, this.angleX, this.angleY, this.entity, gui, EntityRenderMode.FIGURA_GUI);
            pose.m_85849_();
        } else {
            int s = Math.min(width, height) * 2 / 3;
            UIHelper.enableBlend();
            gui.m_280411_(UNKNOWN, x + (width - s) / 2, y + (height - s) / 2, s, s, 0.0f, (float)(64 * ((int)((float)FiguraMod.ticks / 3.0f) % 8)), 64, 64, 64, 512);
        }
        gui.m_280618_();
        super.m_88315_(gui, mouseX, mouseY, delta);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isVisible() || !this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        switch (button) {
            case 0: {
                this.anchorX = (float)mouseX;
                this.anchorY = (float)mouseY;
                this.anchorAngleX = this.angleX;
                this.anchorAngleY = this.angleY;
                this.isRotating = true;
                return true;
            }
            case 1: {
                this.dragDeltaX = (float)mouseX;
                this.dragDeltaY = (float)mouseY;
                this.dragAnchorX = this.modelX;
                this.dragAnchorY = this.modelY;
                this.isDragging = true;
                return true;
            }
            case 2: {
                this.isRotating = false;
                this.isDragging = false;
                this.anchorX = 0.0f;
                this.anchorY = 0.0f;
                this.anchorAngleX = 0.0f;
                this.anchorAngleY = 0.0f;
                this.angleX = this.pitch;
                this.angleY = this.yaw;
                this.scaledValue = 0.0f;
                this.scaledPrecise = 0.0f;
                this.modelX = this.m_5711_() / 2;
                this.modelY = this.m_93694_() / 2;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isRotating = false;
            return true;
        }
        if (button == 1) {
            this.isDragging = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isRotating) {
            this.angleX = (float)((double)this.anchorAngleX + ((double)this.anchorY - mouseY) / (3.0 / Minecraft.m_91087_().m_91268_().m_85449_()));
            this.angleY = (float)((double)this.anchorAngleY - ((double)this.anchorX - mouseX) / (3.0 / Minecraft.m_91087_().m_91268_().m_85449_()));
            if (this.angleX >= 360.0f || this.angleX <= -360.0f) {
                this.anchorY = (float)mouseY;
                this.anchorAngleX = 0.0f;
                this.angleX = 0.0f;
            }
            if (this.angleY >= 360.0f || this.angleY <= -360.0f) {
                this.anchorX = (float)mouseX;
                this.anchorAngleY = 0.0f;
                this.angleY = 0.0f;
            }
            return true;
        }
        if (this.isDragging) {
            float x = (float)(mouseX - (double)this.dragDeltaX);
            float y = (float)(mouseY - (double)this.dragDeltaY);
            this.modelX = (int)(this.dragAnchorX + x);
            this.modelY = (int)(this.dragAnchorY + y);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        float scaleDir = amount > 0.0 ? 1.1f : 0.9090909f;
        this.scaledPrecise = (this.scale + this.scaledPrecise) * scaleDir - this.scale;
        return true;
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public void setToggled(boolean toggled) {
        this.button.setToggled(toggled);
        this.button.setTooltip((Component)(toggled ? FiguraText.of("gui.minimise") : FiguraText.of("gui.expand")));
    }
}

