/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import forge.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import forge.org.figuramc.figura.gui.widgets.Button;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class ContextMenu
extends AbstractContainerElement {
    public static final ResourceLocation BACKGROUND = new FiguraIdentifier("textures/gui/context.png");
    private final int minWidth;
    private final List<ContextButton> entries = new ArrayList<ContextButton>();
    public GuiEventListener parent;
    private ContextMenu nestedContext;

    public ContextMenu(GuiEventListener parent, int minWidth) {
        super(0, 0, minWidth, 2);
        this.minWidth = minWidth;
        this.parent = parent;
        this.setVisible(false);
    }

    public ContextMenu(GuiEventListener parent) {
        this(parent, 0);
    }

    public ContextMenu() {
        this(null);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
        int y = this.m_252907_() + 1;
        for (int i = 0; i < this.entries.size(); ++i) {
            int height = this.entries.get(i).m_93694_();
            UIHelper.blitSliced(gui, this.m_252754_() + 1, y, this.m_5711_() - 2, height, i % 2 == 1 ? 32.0f : 16.0f, 0.0f, 16, 16, 48, 16, BACKGROUND);
            this.entries.get(i).m_88315_(gui, mouseX, mouseY, delta);
            y += height;
        }
        if (this.nestedContext != null) {
            this.nestedContext.m_88315_(gui, mouseX, mouseY, delta);
            GuiEventListener guiEventListener = this.nestedContext.parent;
            if (guiEventListener instanceof Button) {
                Button button = (Button)guiEventListener;
                button.setHovered(true);
            }
        }
    }

    public void addAction(Component name, Component tooltip, Button.OnPress action) {
        this.addElement(new ContextButton(this.m_252754_(), this.m_252907_() + this.m_93694_(), name, tooltip, this, action));
    }

    public void addDivisor() {
        this.addElement(new ContextDivisor(this.m_252754_(), this.m_252907_() + this.m_93694_()));
    }

    public void addTab(Component name, Component tooltip, ContextMenu context) {
        TabButton button = new TabButton(this.m_252754_(), this.m_252907_() + this.m_93694_(), name, tooltip, this, context);
        this.addElement(button);
        context.parent = button;
        this.children.add(context);
    }

    private void addElement(ContextButton element) {
        this.children.add(element);
        this.entries.add(element);
        this.updateDimensions();
    }

    private void clearNest() {
        if (this.nestedContext != null) {
            this.nestedContext.clearNest();
            this.nestedContext = null;
        }
    }

    public void updateDimensions() {
        this.m_93674_(this.minWidth);
        this.setHeight(2);
        for (ContextButton entry : this.entries) {
            this.m_93674_(Math.max(entry.getTrueWidth() + 8, this.m_5711_()));
            this.setHeight(this.m_93694_() + entry.m_93694_());
        }
        for (ContextButton entry : this.entries) {
            entry.m_93674_(this.m_5711_() - 2);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearNest();
    }

    @Override
    public void m_252865_(int x) {
        int clientWidth;
        int realWidth = x + this.m_5711_();
        if (realWidth > (clientWidth = Minecraft.m_91087_().m_91268_().m_85445_())) {
            x -= realWidth - clientWidth;
        }
        super.m_252865_(x);
        for (ContextButton button : this.entries) {
            button.m_252865_(x + 1);
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.m_252865_(tab.m_252754_() + tab.m_5711_());
        }
    }

    @Override
    public void m_253211_(int y) {
        int clientHeight;
        int realHeight = y + this.m_93694_();
        if (realHeight > (clientHeight = Minecraft.m_91087_().m_91268_().m_85446_())) {
            y -= realHeight - clientHeight;
        }
        super.m_253211_(y);
        int heigth = y + 1;
        for (ContextButton button : this.entries) {
            button.m_253211_(heigth);
            heigth += button.m_93694_();
            if (!(button instanceof TabButton)) continue;
            TabButton tab = (TabButton)button;
            tab.context.m_253211_(tab.m_252907_() - 1);
        }
    }

    public List<? extends AbstractWidget> getEntries() {
        return this.entries;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result = super.m_6375_(mouseX, mouseY, button);
        this.m_7522_(null);
        return result;
    }

    private static class ContextButton
    extends Button {
        protected final ContextMenu parent;

        public ContextButton(int x, int y, Component text, Component tooltip, ContextMenu parent, Button.OnPress pressAction) {
            super(x, y, 0, 16, text, tooltip, pressAction);
            this.shouldHaveBackground(false);
            this.parent = parent;
        }

        protected ContextButton(int x, int y, int height) {
            super(x, y, 0, height, (Component)Component.m_237119_(), null, button -> {});
            this.shouldHaveBackground(false);
            this.parent = null;
        }

        @Override
        protected void renderText(GuiGraphics gui, float delta) {
            Font font = Minecraft.m_91087_().f_91062_;
            Component component = this.m_6035_();
            int n = this.m_252754_() + 3;
            float f = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
            Objects.requireNonNull(font);
            gui.m_280430_(font, component, n, (int)(f - 9.0f / 2.0f), this.getTextColor());
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            if (UIHelper.isMouseOver(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mouseX, mouseY, true)) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.clearNest();
                return true;
            }
            return false;
        }

        public int getTrueWidth() {
            return Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.m_6035_());
        }
    }

    private static class ContextDivisor
    extends ContextButton {
        public ContextDivisor(int x, int y) {
            super(x, y, 9);
        }

        @Override
        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            gui.m_280509_(this.m_252754_() + 4, this.m_252907_() + 4, this.m_252754_() + this.m_5711_() - 4, this.m_252907_() + 5, -16777216 + ChatFormatting.DARK_GRAY.m_126665_());
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return false;
        }
    }

    private static class TabButton
    extends ContextButton {
        private static final Component ARROW = Component.m_237113_((String)">").m_6270_(Style.f_131099_.m_131150_(UIHelper.UI_FONT));
        private final ContextMenu context;

        public TabButton(int x, int y, Component text, Component tooltip, ContextMenu parent, ContextMenu context) {
            super(x, y, text, tooltip, parent, button -> {});
            this.context = context;
            this.context.setVisible(true);
        }

        @Override
        public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
            super.m_87963_(gui, mouseX, mouseY, delta);
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.m_252754_() + this.m_5711_() - font.m_92852_((FormattedText)ARROW) - 3;
            float f = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
            Objects.requireNonNull(font);
            gui.m_280430_(font, ARROW, n, (int)(f - 9.0f / 2.0f), this.getTextColor());
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            boolean mouseOver = UIHelper.isMouseOver(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mouseX, mouseY, true);
            if (mouseOver || this.parent.nestedContext == this.context) {
                UIHelper.setTooltip(this.tooltip);
                this.parent.nestedContext = this.context;
                if (mouseOver) {
                    this.context.nestedContext = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public int getTrueWidth() {
            return super.getTrueWidth() + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)Component.m_237113_((String)" ").m_7220_(ARROW));
        }
    }
}

