/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.font;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.font.EmojiContainer;
import forge.org.figuramc.figura.utils.FiguraResourceListener;
import forge.org.figuramc.figura.utils.TextUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class Emojis {
    private static final Map<String, EmojiContainer> EMOJIS = new HashMap<String, EmojiContainer>();
    private static final Map<String, EmojiContainer> SHORTCUT_LOOKUP = new HashMap<String, EmojiContainer>();
    public static final char DELIMITER = ':';
    public static final char ESCAPE = '\\';
    public static final FiguraResourceListener RESOURCE_LISTENER = FiguraResourceListener.createResourceListener("emojis", manager -> {
        EMOJIS.clear();
        for (Map.Entry emojis : manager.m_214159_("emojis", location -> location.m_135827_().equals("figura") && location.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation location2 = (ResourceLocation)emojis.getKey();
            String[] split = location2.m_135815_().split("/", 2);
            if (split.length <= 1) continue;
            String name = split[1].substring(0, split[1].length() - 5);
            try {
                InputStream stream = ((Resource)emojis.getValue()).m_215507_();
                try {
                    JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
                    EmojiContainer container = new EmojiContainer(name, json);
                    EMOJIS.put(name, container);
                    container.getLookup().getShortcuts().forEach(shortcut -> SHORTCUT_LOOKUP.put((String)shortcut, container));
                    HashSet<String> set = new HashSet<String>();
                    for (EmojiContainer emoji : EMOJIS.values()) {
                        for (String s : emoji.getLookup().getNames()) {
                            if (set.add(s)) continue;
                            FiguraMod.LOGGER.warn("Duplicate emoji id registered {}", (Object)s);
                        }
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to load {} emojis", (Object)name, (Object)e);
            }
        }
    });

    public static Collection<String> getCategoryNames() {
        return EMOJIS.keySet();
    }

    public static EmojiContainer getCategory(String key) {
        return EMOJIS.get(key);
    }

    public static boolean hasCategory(String key) {
        return EMOJIS.containsKey(key);
    }

    public static MutableComponent applyEmojis(Component text) {
        Component newText = TextUtils.parseLegacyFormatting((FormattedText)text);
        MutableComponent ret = Component.m_237119_();
        newText.m_7451_((style, string) -> {
            ret.m_7220_((Component)Emojis.convertEmoji(string, style));
            return Optional.empty();
        }, Style.f_131099_);
        return ret;
    }

    private static MutableComponent convertEmoji(String string, Style style) {
        Object s;
        ArrayList<Object> strings = new ArrayList<Object>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        boolean inside = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (i + 1 != string.length() && string.charAt(i + 1) == ':') continue;
                current.append(c);
                continue;
            }
            if (c == ':' && !escaped) {
                inside = !inside;
                strings.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            escaped = false;
            current.append(c);
            if (c != ' ' || !inside) continue;
            inside = false;
            String removed = (String)strings.remove(strings.size() - 1);
            current = new StringBuilder(removed).append(':').append((CharSequence)current);
        }
        if (current.length() > 0 || inside) {
            String toAdd = current.toString();
            if (inside) {
                int index = strings.size() - 1;
                s = (String)strings.get(index) + ":" + toAdd;
                strings.set(index, s);
            } else {
                strings.add(toAdd);
            }
        }
        MutableComponent result = Component.m_237119_().m_130948_(style);
        for (int i = 0; i < strings.size(); ++i) {
            s = (String)strings.get(i);
            if (i % 2 == 0) {
                List<String> shortcuts = SHORTCUT_LOOKUP.keySet().stream().filter(((String)s)::contains).toList();
                if (shortcuts.size() > 0) {
                    while (((String)s).length() > 0) {
                        boolean anyFound = false;
                        for (String shortcut : shortcuts) {
                            if (!((String)s).startsWith(shortcut)) continue;
                            s = ((String)s).substring(shortcut.length());
                            result.m_7220_(SHORTCUT_LOOKUP.get(shortcut).getShortcutComponent(shortcut));
                            anyFound = true;
                            break;
                        }
                        if (anyFound) continue;
                        result.m_130946_(String.valueOf(((String)s).charAt(0)));
                        s = ((String)s).substring(1);
                    }
                    continue;
                }
                result.m_130946_((String)s);
                continue;
            }
            Emojis.appendEmoji(result, (String)s, Emojis::getEmoji);
        }
        return result;
    }

    private static void appendEmoji(MutableComponent result, String s, Function<String, Component> converter) {
        Component emoji = converter.apply(s);
        if (emoji != null) {
            result.m_7220_(emoji);
        } else {
            result.m_130946_(":" + s + ":");
        }
    }

    public static Component getEmoji(String emojiAlias) {
        for (EmojiContainer container : EMOJIS.values()) {
            Component emoji = container.getEmojiComponent(emojiAlias);
            if (emoji == null) continue;
            return emoji;
        }
        return null;
    }

    public static EmojiContainer getCategoryByFont(ResourceLocation location) {
        for (EmojiContainer container : EMOJIS.values()) {
            if (!location.equals((Object)container.getFont())) continue;
            return container;
        }
        return null;
    }

    public static Component removeBlacklistedEmojis(Component text) {
        for (EmojiContainer container : EMOJIS.values()) {
            text = container.blacklist(text);
        }
        return text;
    }

    public static List<String> getMatchingEmojis(String query) {
        if (query.length() == 0 || query.charAt(0) != ':') {
            return List.of();
        }
        String name = query.substring(1);
        ArrayList<String> emojis = new ArrayList<String>();
        for (EmojiContainer container : EMOJIS.values()) {
            for (String s : container.getLookup().getNames()) {
                if (!s.startsWith(name)) continue;
                emojis.add(":" + s + ":");
            }
        }
        return emojis;
    }

    public static void tickAnimations() {
        for (EmojiContainer container : EMOJIS.values()) {
            container.tickAnimations();
        }
    }
}

