/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forge.org.figuramc.figura.commands.FiguraCommands;
import forge.org.figuramc.figura.lua.FiguraLuaPrinter;
import forge.org.figuramc.figura.lua.FiguraLuaRuntime;
import forge.org.figuramc.figura.utils.FiguraClientCommandSource;

class RunCommand {
    RunCommand() {
    }

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder run = LiteralArgumentBuilder.literal((String)"run");
        RequiredArgumentBuilder arg = RequiredArgumentBuilder.argument((String)"code", (ArgumentType)StringArgumentType.greedyString());
        arg.executes(RunCommand::executeCode);
        run.then((ArgumentBuilder)arg);
        return run;
    }

    private static int executeCode(CommandContext<FiguraClientCommandSource> context) {
        String lua = StringArgumentType.getString(context, (String)"code");
        FiguraLuaRuntime luaRuntime = FiguraCommands.getRuntime(context);
        if (luaRuntime == null) {
            return 0;
        }
        try {
            luaRuntime.load("runCommand", lua).call();
            return 1;
        }
        catch (Exception | StackOverflowError e) {
            FiguraLuaPrinter.sendLuaError(FiguraLuaRuntime.parseError(e), luaRuntime.owner);
            return 0;
        }
    }
}

