/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.backend2.websocket;

import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.backend2.NetworkStuff;
import forge.org.figuramc.figura.backend2.websocket.C2SMessageHandler;
import forge.org.figuramc.figura.backend2.websocket.S2CMessageHandler;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.gui.FiguraToast;
import forge.org.figuramc.figura.utils.FiguraText;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebsocketThingy
extends WebSocketClient {
    public static final Map<Integer, String> ERROR_CODES = new HashMap<Integer, String>(){
        {
            this.put(1000, "Normal Closure");
            this.put(1001, "Going Away");
            this.put(1002, "Protocol Error");
            this.put(1003, "Unsupported Data");
            this.put(1005, "No Status Received");
            this.put(1006, "Abnormal Closure");
            this.put(1007, "Invalid Frame Payload Data");
            this.put(1008, "Policy Violation");
            this.put(1009, "Message Too Big");
            this.put(1010, "Mandatory Ext.");
            this.put(1011, "Internal Error");
            this.put(1012, "Service Restart");
            this.put(1013, "Try Again Later");
            this.put(1014, "Bad Gateway");
            this.put(1015, "TLS Handshake");
            this.put(3000, "Unauthorized");
            this.put(4000, "Re-Auth");
            this.put(4001, "Banned");
            this.put(4002, "Too Many Connections");
        }
    };
    private final String token;

    public WebsocketThingy(String token) {
        super(URI.create(WebsocketThingy.getBackendAddress()));
        this.token = token;
    }

    public void onOpen(ServerHandshake handshakedata) {
        FiguraMod.LOGGER.info("Connecting to Figura ws backend (" + WebsocketThingy.getBackendAddress() + ")");
        try {
            this.send(C2SMessageHandler.auth(this.token));
        }
        catch (Exception e) {
            this.handleClose(-1, e.getMessage());
        }
    }

    public void onMessage(String message) {
    }

    public void onMessage(ByteBuffer bytes) {
        if (NetworkStuff.debug) {
            FiguraMod.debug("Received raw ws message of " + bytes.remaining() + "b", new Object[0]);
        }
        try {
            S2CMessageHandler.handle(bytes);
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to handle ws message", (Throwable)e);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        reason = reason.isBlank() ? ERROR_CODES.getOrDefault(code, "Unknown") : reason;
        FiguraMod.LOGGER.info("Closed connection: " + reason + ", Code: " + code + ", Remote: " + remote);
        this.handleClose(code, reason + (String)(FiguraMod.debugModeEnabled() ? "\n\nCode: " + code + "\nRemote: " + remote : ""));
    }

    public void onError(Exception e) {
        FiguraMod.LOGGER.warn("", (Throwable)e);
        this.handleClose(-1, e.getMessage());
    }

    public void send(ByteBuffer bytes) {
        if (NetworkStuff.debug) {
            FiguraMod.debug("Sent raw ws message of " + bytes.remaining() + "b", new Object[0]);
        }
        super.send(bytes);
    }

    private static String getBackendAddress() {
        ServerAddress backendIP = ServerAddress.m_171864_((String)((String)Configs.SERVER_IP.value));
        return "wss://" + backendIP.m_171863_() + "/ws";
    }

    private void handleClose(int code, String reason) {
        if (((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
            FiguraToast.sendToast((Object)FiguraText.of("backend.disconnected"), FiguraToast.ToastType.ERROR);
        }
        NetworkStuff.disconnect(reason);
        if (code == 4000) {
            NetworkStuff.reAuth();
        }
    }
}

