/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.backend2.websocket;

import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.backend2.NetworkStuff;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.gui.FiguraToast;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.FiguraText;
import forge.org.figuramc.figura.utils.TextUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.chat.Component;

public class S2CMessageHandler {
    public static final byte AUTH = 0;
    public static final byte PING = 1;
    public static final byte EVENT = 2;
    public static final byte TOAST = 3;
    public static final byte CHAT = 4;
    public static final byte NOTICE = 5;

    public static void handle(ByteBuffer bytes) {
        if (!bytes.hasRemaining()) {
            return;
        }
        byte b = bytes.get();
        if (NetworkStuff.debug) {
            FiguraMod.debug("Got ws message of type: " + b, new Object[0]);
        }
        switch (b) {
            case 0: {
                S2CMessageHandler.auth();
                break;
            }
            case 1: {
                S2CMessageHandler.ping(bytes);
                break;
            }
            case 2: {
                S2CMessageHandler.event(bytes);
                break;
            }
            case 3: {
                S2CMessageHandler.toast(bytes);
                break;
            }
            case 4: {
                S2CMessageHandler.chat(bytes);
                break;
            }
            case 5: {
                S2CMessageHandler.notice(bytes);
            }
        }
    }

    private static void auth() {
        FiguraMod.LOGGER.info("Connected to Figura ws backend");
        NetworkStuff.backendStatus = 3;
        NetworkStuff.subscribeAll();
        if (((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
            FiguraToast.sendToast(FiguraText.of("backend.connected"));
        }
    }

    private static void ping(ByteBuffer bytes) {
        UUID uuid = new UUID(bytes.getLong(), bytes.getLong());
        Avatar avatar = AvatarManager.getLoadedAvatar(uuid);
        if (avatar == null) {
            return;
        }
        int id = bytes.getInt();
        bytes.get();
        byte[] data = new byte[bytes.remaining()];
        bytes.get(data);
        avatar.runPing(id, data);
        ++NetworkStuff.pingsReceived;
        if (NetworkStuff.lastPing == 0) {
            NetworkStuff.lastPing = FiguraMod.ticks;
        }
    }

    private static void event(ByteBuffer bytes) {
        UUID uuid = new UUID(bytes.getLong(), bytes.getLong());
        AvatarManager.reloadAvatar(uuid);
    }

    private static void toast(ByteBuffer bytes) {
        byte type = bytes.get();
        String[] str = StandardCharsets.UTF_8.decode(bytes).toString().split("\u0000", 2);
        FiguraToast.sendToast(str[0], str.length > 1 ? str[1] : "", FiguraToast.ToastType.values()[type]);
    }

    private static void chat(ByteBuffer bytes) {
        String message = StandardCharsets.UTF_8.decode(bytes).toString();
        FiguraMod.sendChatMessage((Component)Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"-- Figura backend message --\n\n").m_130948_(ColorUtils.Colors.SOFT_BLUE.style)).m_7220_(TextUtils.tryParseJson(message)));
    }

    private static void notice(ByteBuffer bytes) {
        if (!((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
            return;
        }
        byte type = bytes.get();
        switch (type) {
            case 0: {
                FiguraToast.sendToast(FiguraText.of("backend.warning"), FiguraText.of("backend.ping_size"), FiguraToast.ToastType.ERROR);
                break;
            }
            case 1: {
                FiguraToast.sendToast(FiguraText.of("backend.warning"), FiguraText.of("backend.ping_rate"), FiguraToast.ToastType.ERROR);
            }
        }
    }
}

