/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura;

import com.mojang.authlib.GameProfile;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.local.CacheAvatarLoader;
import forge.org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import forge.org.figuramc.figura.avatar.local.LocalAvatarLoader;
import forge.org.figuramc.figura.backend2.NetworkStuff;
import forge.org.figuramc.figura.config.ConfigManager;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.entries.EntryPointManager;
import forge.org.figuramc.figura.font.Emojis;
import forge.org.figuramc.figura.lua.FiguraLuaPrinter;
import forge.org.figuramc.figura.lua.docs.FiguraDocsManager;
import forge.org.figuramc.figura.mixin.SkullBlockEntityAccessor;
import forge.org.figuramc.figura.permissions.PermissionManager;
import forge.org.figuramc.figura.resources.FiguraRuntimeResources;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.FiguraModMetadata;
import forge.org.figuramc.figura.utils.FiguraResourceListener;
import forge.org.figuramc.figura.utils.IOUtils;
import forge.org.figuramc.figura.utils.PlatformUtils;
import forge.org.figuramc.figura.utils.TextUtils;
import forge.org.figuramc.figura.utils.Version;
import forge.org.figuramc.figura.wizards.AvatarWizard;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiguraMod {
    public static final String MOD_ID = "figura";
    public static final String MOD_NAME = "Figura";
    public static final FiguraModMetadata METADATA = FiguraModMetadata.getMetadataForMod("figura");
    public static final Version VERSION = new Version(PlatformUtils.getModVersionString());
    public static final Calendar CALENDAR = Calendar.getInstance();
    public static final Path GAME_DIR = PlatformUtils.getGameDir().normalize();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Figura");
    public static final float VERTEX_OFFSET = -5.0E-4f;
    public static int ticks;
    public static Entity extendedPickEntity;
    public static Component splashText;
    public static boolean parseMessages;
    public static boolean processingKeybind;

    public static boolean debugModeEnabled() {
        return Configs.DEBUG_MODE != null && (Boolean)Configs.DEBUG_MODE.value != false;
    }

    public static void onClientInit() {
        EntryPointManager.init();
        ConfigManager.init();
        PermissionManager.init();
        LocalAvatarFetcher.init();
        CacheAvatarLoader.init();
        FiguraDocsManager.init();
        FiguraRuntimeResources.init();
    }

    public static List<FiguraResourceListener> getResourceListeners() {
        ArrayList<FiguraResourceListener> listeners = new ArrayList<FiguraResourceListener>();
        listeners.add(LocalAvatarLoader.AVATAR_LISTENER);
        listeners.add(Emojis.RESOURCE_LISTENER);
        listeners.add(AvatarWizard.RESOURCE_LISTENER);
        listeners.add(AvatarManager.RESOURCE_RELOAD_EVENT);
        return listeners;
    }

    public static void tick() {
        FiguraMod.pushProfiler("network");
        NetworkStuff.tick();
        FiguraMod.popPushProfiler("files");
        LocalAvatarLoader.tick();
        LocalAvatarFetcher.tick();
        FiguraMod.popPushProfiler("avatars");
        AvatarManager.tickLoadedAvatars();
        FiguraMod.popPushProfiler("chatPrint");
        FiguraLuaPrinter.printChatFromQueue();
        FiguraMod.popPushProfiler("emojiAnim");
        Emojis.tickAnimations();
        FiguraMod.popProfiler();
        ++ticks;
    }

    public static void debug(String str, Object ... args) {
        if (FiguraMod.debugModeEnabled()) {
            LOGGER.info("[DEBUG] " + str, args);
        } else {
            LOGGER.debug(str, args);
        }
    }

    public static Path getFiguraDirectory() {
        String config = (String)Configs.MAIN_DIR.value;
        Path p = config.isBlank() ? GAME_DIR.resolve(MOD_ID) : Path.of(config, new String[0]);
        return IOUtils.createDirIfNeeded(p);
    }

    public static Path getCacheDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getFiguraDirectory(), (Boolean)Configs.LOCAL_ASSETS.value != false ? "local_cache" : "cache");
    }

    public static UUID getLocalPlayerUUID() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null ? player.m_20148_() : Minecraft.m_91087_().m_91094_().m_92548_().getId();
    }

    public static boolean isLocal(UUID other) {
        return FiguraMod.getLocalPlayerUUID().equals(other);
    }

    public static void sendChatMessage(Component message) {
        if (Minecraft.m_91087_().f_91065_ != null) {
            parseMessages = false;
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(TextUtils.replaceTabs((FormattedText)message));
            parseMessages = true;
        } else {
            LOGGER.info(message.getString());
        }
    }

    public static UUID playerNameToUUID(String playerName) {
        GameProfileCache cache = SkullBlockEntityAccessor.getProfileCache();
        if (cache == null) {
            return null;
        }
        Optional profile = cache.m_10996_(playerName);
        return profile.isEmpty() ? null : ((GameProfile)profile.get()).getId();
    }

    public static Style getAccentColor() {
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        int color = avatar != null ? ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.color, ColorUtils.Colors.AWESOME_BLUE.vec)) : ColorUtils.Colors.AWESOME_BLUE.hex;
        return Style.f_131099_.m_178520_(color);
    }

    public static void pushProfiler(String name) {
        Minecraft.m_91087_().m_91307_().m_6180_(name);
    }

    public static void pushProfiler(Avatar avatar) {
        Minecraft.m_91087_().m_91307_().m_6180_(avatar.entityName.isBlank() ? avatar.owner.toString() : avatar.entityName);
    }

    public static void popPushProfiler(String name) {
        Minecraft.m_91087_().m_91307_().m_6182_(name);
    }

    public static void popProfiler() {
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static <T> T popReturnProfiler(T var) {
        Minecraft.m_91087_().m_91307_().m_7238_();
        return var;
    }

    public static void popProfiler(int times) {
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        for (int i = 0; i < times; ++i) {
            profiler.m_7238_();
        }
    }

    static {
        parseMessages = true;
    }

    public static enum Links {
        Wiki("https://github.com/KitCat962/FiguraRewriteRewrite/wiki", ColorUtils.Colors.AWESOME_BLUE.style),
        Kofi("https://ko-fi.com/skyrina", ColorUtils.Colors.KOFI.style),
        OpenCollective("https://opencollective.com/figura", ColorUtils.Colors.KOFI.style),
        Discord("https://discord.gg/figuramc", ColorUtils.Colors.DISCORD.style),
        Github("https://github.com/FiguraMC/Figura", ColorUtils.Colors.GITHUB.style),
        Modrinth("https://modrinth.com/mod/figura", ColorUtils.Colors.MODRINTH.style),
        Curseforge("https://www.curseforge.com/minecraft/mc-mods/figura", ColorUtils.Colors.CURSEFORGE.style),
        LuaManual("https://www.lua.org/manual/5.2/manual.html", ColorUtils.Colors.LUA_LOG.style);

        public final String url;
        public final Style style;

        private Links(String url, Style style) {
            this.url = url;
            this.style = style;
        }
    }
}

