/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.lua.api.world.BlockStateAPI;
import fabric.org.figuramc.figura.lua.api.world.ItemStackAPI;
import fabric.org.figuramc.figura.lua.api.world.WorldAPI;
import fabric.org.figuramc.figura.math.vector.FiguraVec2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2240;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaUtils {
    public static FiguraVec4 parseVec4(String methodName, Object x, Number y, Number z, Number w, double defaultX, double defaultY, double defaultZ, double defaultW) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return FiguraVec4.of(vec.x, vec.y, vec.z, defaultW);
        }
        if (x instanceof FiguraVec4) {
            FiguraVec4 vec = (FiguraVec4)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            if (w == null) {
                w = defaultW;
            }
            return FiguraVec4.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue(), w.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Pair<FiguraVec3, FiguraVec3> parse2Vec3(String methodName, Object x, Object y, Number z, Object w, Number t, Number h) {
        FiguraVec3 b;
        FiguraVec3 a;
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec1 = (FiguraVec3)x;
            a = vec1.copy();
            if (y instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)y;
                b = vec2.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (y != null && !(y instanceof Number)) throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(y));
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(w));
                b = LuaUtils.parseVec3(methodName, y, z, (Number)w);
            }
            return Pair.of((Object)a, (Object)b);
        } else {
            if (x != null && (!(x instanceof Number) || y != null) && !(y instanceof Number)) throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(x));
            a = LuaUtils.parseVec3(methodName, x, (Number)y, z);
            if (w instanceof FiguraVec3) {
                FiguraVec3 vec1 = (FiguraVec3)w;
                b = vec1.copy();
                return Pair.of((Object)a, (Object)b);
            } else {
                if (w != null && !(w instanceof Number)) throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(w));
                b = LuaUtils.parseVec3(methodName, w, t, h);
            }
        }
        return Pair.of((Object)a, (Object)b);
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z) {
        return LuaUtils.parseVec3(methodName, x, y, z, 0.0, 0.0, 0.0);
    }

    public static FiguraVec3 parseVec3(String methodName, Object x, Number y, Number z, double defaultX, double defaultY, double defaultZ) {
        if (x instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            if (z == null) {
                z = defaultZ;
            }
            return FiguraVec3.of(((Number)x).doubleValue(), y.doubleValue(), z.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static FiguraVec3 parseOneArgVec(String methodName, Object x, Number y, Number z, double defaultArg) {
        double d;
        if (x instanceof Number) {
            Number n = (Number)x;
            d = n.doubleValue();
        } else {
            d = defaultArg;
        }
        double d2 = d;
        return LuaUtils.parseVec3(methodName, x, y, z, d2, d2, d2);
    }

    public static FiguraVec3 nullableVec3(String methodName, Object x, Number y, Number z) {
        return x == null ? null : LuaUtils.parseVec3(methodName, x, y, z);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y) {
        return LuaUtils.parseVec2(methodName, x, y, 0.0, 0.0);
    }

    public static FiguraVec2 parseVec2(String methodName, Object x, Number y, double defaultX, double defaultY) {
        if (x instanceof FiguraVec2) {
            FiguraVec2 vec = (FiguraVec2)x;
            return vec.copy();
        }
        if (x == null || x instanceof Number) {
            if (x == null) {
                x = defaultX;
            }
            if (y == null) {
                y = defaultY;
            }
            return FiguraVec2.of(((Number)x).doubleValue(), y.doubleValue());
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + x.getClass().getSimpleName());
    }

    public static class_1799 parseItemStack(String methodName, Object item) {
        if (item == null) {
            return class_1799.field_8037;
        }
        if (item instanceof ItemStackAPI) {
            ItemStackAPI wrapper = (ItemStackAPI)item;
            return wrapper.itemStack;
        }
        if (item instanceof String) {
            String string = (String)item;
            try {
                class_1937 level = WorldAPI.getCurrentWorld();
                return class_2287.method_9776((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9778(new StringReader(string)).method_9781(1, false);
            }
            catch (Exception e) {
                throw new LuaError("Could not parse item stack from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(item));
    }

    public static class_2680 parseBlockState(String methodName, Object block) {
        if (block == null) {
            return class_2246.field_10124.method_9564();
        }
        if (block instanceof BlockStateAPI) {
            BlockStateAPI wrapper = (BlockStateAPI)block;
            return wrapper.blockState;
        }
        if (block instanceof String) {
            String string = (String)block;
            try {
                class_1937 level = WorldAPI.getCurrentWorld();
                return class_2257.method_9653((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9654(new StringReader(string)).method_9494();
            }
            catch (Exception e) {
                throw new LuaError("Could not parse block state from string: " + string);
            }
        }
        throw new LuaError("Illegal argument to " + methodName + "(): " + String.valueOf(block));
    }

    public static class_2960 parsePath(String path) {
        try {
            return new class_2960(path);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    public static Object[] parseBlockHitResult(class_239 hitResult) {
        if (hitResult instanceof class_3965) {
            class_3965 blockHit = (class_3965)hitResult;
            class_2338 pos = blockHit.method_17777();
            return new Object[]{new BlockStateAPI(WorldAPI.getCurrentWorld().method_8320(pos), pos), FiguraVec3.fromVec3(blockHit.method_17784()), blockHit.method_17780().method_10151()};
        }
        return null;
    }

    public static int parseSlot(Object slot, class_1661 inventory) {
        if (slot instanceof String) {
            String s = (String)slot;
            try {
                return class_2240.method_9473().method_9470(new StringReader(s));
            }
            catch (Exception e) {
                throw new LuaError("Unable to get slot \"" + String.valueOf(slot) + "\"");
            }
        }
        if (slot instanceof Integer) {
            Integer i = (Integer)slot;
            if (i == -1 && inventory != null) {
                return inventory.method_7376();
            }
            return i;
        }
        throw new LuaError("Invalid type for getSlot: " + slot.getClass().getSimpleName());
    }

    public static JsonElement asJsonValue(LuaValue value) {
        if (value.isnil()) {
            return JsonNull.INSTANCE;
        }
        if (value.isboolean()) {
            return new JsonPrimitive(Boolean.valueOf(value.checkboolean()));
        }
        if (value.isint()) {
            return new JsonPrimitive((Number)value.checkint());
        }
        if (value.isnumber()) {
            return new JsonPrimitive((Number)value.checkdouble());
        }
        if (value.isstring()) {
            return new JsonPrimitive(value.checkjstring());
        }
        if (value.istable()) {
            LuaTable table = value.checktable();
            if (LuaUtils.checkTableArray(table)) {
                JsonArray arr = new JsonArray();
                for (int i = 0; i < table.length(); ++i) {
                    arr.add(LuaUtils.asJsonValue(table.get(i + 1)));
                }
                return arr;
            }
            JsonObject object = new JsonObject();
            for (LuaValue key : table.keys()) {
                object.add(key.tojstring(), LuaUtils.asJsonValue(table.get(key)));
            }
            return object;
        }
        return null;
    }

    public static boolean checkTableArray(LuaTable table) {
        for (LuaValue key : table.keys()) {
            if (key.isnumber()) continue;
            return false;
        }
        return true;
    }
}

