/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fabric.org.figuramc.figura.FiguraMod;
import java.util.function.Function;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class JsonUtils {
    public static boolean validate(JsonObject object, String fieldName, Function<JsonElement, Boolean> validator) {
        return object.has(fieldName) && validator.apply(object.get(fieldName)) != false;
    }

    public static boolean validate(JsonObject object, String fieldName, Function<JsonElement, Boolean> validator, String warningMessage, Object ... params) {
        if (!JsonUtils.validate(object, fieldName, validator)) {
            FiguraMod.LOGGER.warn(warningMessage, params);
            return false;
        }
        return true;
    }

    public static int getIntOrDefault(JsonObject object, String fieldName, int fallback) {
        if (JsonUtils.validate(object, fieldName, JsonElement::isJsonPrimitive)) {
            return object.get(fieldName).getAsInt();
        }
        return fallback;
    }

    public static LuaValue asLuaValue(JsonElement value) {
        if (value.isJsonPrimitive()) {
            JsonPrimitive p = value.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return LuaValue.valueOf((boolean)p.getAsBoolean());
            }
            if (p.isNumber()) {
                return LuaValue.valueOf((double)p.getAsNumber().doubleValue());
            }
            if (p.isString()) {
                return LuaValue.valueOf((String)p.getAsString());
            }
            return LuaValue.valueOf((String)value.getAsString());
        }
        if (value.isJsonArray()) {
            JsonArray arr = value.getAsJsonArray();
            LuaTable table = new LuaTable();
            for (JsonElement element : arr) {
                table.insert(table.length() + 1, JsonUtils.asLuaValue(element));
            }
            return table;
        }
        if (value.isJsonNull()) {
            return LuaValue.NIL;
        }
        if (value.isJsonObject()) {
            JsonObject obj = value.getAsJsonObject();
            LuaTable table = new LuaTable();
            for (String key : obj.keySet()) {
                table.set(key, JsonUtils.asLuaValue(obj.get(key)));
            }
            return table;
        }
        return LuaValue.NIL;
    }
}

