/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.utils;

import fabric.org.figuramc.figura.FiguraMod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class IOUtils {
    public static final String INVALID_FILENAME_REGEX = "CON|PRN|AUX|NUL|COM\\d|LPT\\d|[\\\\/:*?\"<>|\u0000]|\\.$";

    public static List<Path> getFilesByExtension(Path root, String extension) {
        ArrayList<Path> result = new ArrayList<Path>();
        List<Path> children = IOUtils.listPaths(root);
        if (children == null) {
            return result;
        }
        for (Path child : children) {
            if (IOUtils.isHidden(child)) continue;
            if (Files.isDirectory(child, new LinkOption[0])) {
                result.addAll(IOUtils.getFilesByExtension(child, extension));
                continue;
            }
            if (!child.toString().toLowerCase().endsWith(extension.toLowerCase())) continue;
            result.add(child);
        }
        return result;
    }

    public static String readFile(Path file) throws IOException {
        String string;
        block8: {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            try {
                string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    FiguraMod.LOGGER.error("Failed to read File: " + String.valueOf(file));
                    throw e;
                }
            }
            stream.close();
        }
        return string;
    }

    public static byte[] readFileBytes(Path file) throws IOException {
        byte[] byArray;
        block8: {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    FiguraMod.LOGGER.error("Failed to read File: " + String.valueOf(file));
                    throw e;
                }
            }
            stream.close();
        }
        return byArray;
    }

    public static void readCacheFile(String name, Consumer<class_2487> consumer) {
        try {
            Path path = FiguraMod.getCacheDirectory().resolve(name + ".nbt");
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            InputStream fis = Files.newInputStream(path, new OpenOption[0]);
            class_2487 nbt = class_2507.method_10629((InputStream)fis);
            consumer.accept(nbt);
            fis.close();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
        }
    }

    public static void saveCacheFile(String name, Consumer<class_2487> consumer) {
        try {
            class_2487 nbt = new class_2487();
            consumer.accept(nbt);
            Path path = FiguraMod.getCacheDirectory().resolve(name + ".nbt");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            OutputStream fs = Files.newOutputStream(path, new OpenOption[0]);
            class_2507.method_10634((class_2487)nbt, (OutputStream)fs);
            fs.close();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
        }
    }

    public static void deleteCacheFile(String name) {
        Path path = FiguraMod.getCacheDirectory().resolve(name + ".nbt");
        IOUtils.deleteFile(path);
    }

    public static Path getOrCreateDir(Path startingPath, String dir) {
        return IOUtils.createDirIfNeeded(startingPath.resolve(dir));
    }

    public static Path createDirIfNeeded(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to create directory", (Throwable)e);
        }
        return path;
    }

    public static void deleteFile(Path file) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                return;
            }
            List<Path> paths = IOUtils.listPaths(file);
            if (paths != null) {
                for (Path path : paths) {
                    IOUtils.deleteFile(path);
                }
            }
            Files.delete(file);
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to delete " + String.valueOf(file), (Throwable)e);
        }
    }

    public static void writeFile(Path path, byte[] data) throws IOException {
        if (data == null) {
            return;
        }
        try (OutputStream fs = Files.newOutputStream(path, new OpenOption[0]);){
            fs.write(data);
        }
    }

    public static List<Path> listPaths(Path dir) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.list(dir);
            try {
                list = stream.sorted(Comparator.comparing(IOUtils::getFileNameOrEmpty)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            stream.close();
        }
        return list;
    }

    public static String getFileNameOrEmpty(Path path) {
        Path filename = path.getFileName();
        return filename == null ? "" : filename.toString();
    }

    public static boolean isHidden(Path path) {
        boolean hidden;
        try {
            hidden = Files.isHidden(path);
        }
        catch (IOException e) {
            FiguraMod.LOGGER.error("Failed to get if \"" + String.valueOf(path) + "\" is hidden", (Throwable)e);
            hidden = false;
        }
        return hidden || IOUtils.getFileNameOrEmpty(path).startsWith(".");
    }

    public static class DirWrapper {
        private final Path path;

        public DirWrapper(Path path) {
            this.path = path;
        }

        public DirWrapper create() {
            IOUtils.createDirIfNeeded(this.path);
            return this;
        }

        public DirWrapper write(String relativePath, byte[] data) throws IOException {
            IOUtils.writeFile(this.path.resolve(relativePath), data);
            return this;
        }
    }
}

