/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.model.rendertasks;

import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.Badges;
import fabric.org.figuramc.figura.font.Emojis;
import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.model.FiguraModelPart;
import fabric.org.figuramc.figura.model.rendertasks.RenderTask;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.LuaUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.joml.Matrix4f;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="TextTask", value="text_task")
public class TextTask
extends RenderTask {
    private String textCached;
    private List<class_2561> text;
    private TextUtils.Alignment alignment = TextUtils.Alignment.LEFT;
    private boolean shadow = false;
    private boolean outline = false;
    private boolean background = false;
    private boolean seeThrough = false;
    private Integer outlineColor;
    private Integer backgroundColor;
    private int opacity = 255;
    private int width = 0;
    private boolean wrap = true;
    private int cachedComplexity;
    private int cacheWidth;
    private int cacheHeight;

    public TextTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 buffer, int light, int overlay) {
        float vertexOffset;
        int l;
        if (this.opacity == 0) {
            return;
        }
        Matrix4f matrix = poseStack.method_23760().method_23761();
        matrix.scale(-1.0f, -1.0f, -1.0f);
        class_327 font = class_310.method_1551().field_1772;
        int n = l = this.customization.light != null ? this.customization.light : light;
        int bg = this.backgroundColor != null ? this.backgroundColor : (this.background ? (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24 : 0);
        int out = this.outlineColor != null ? this.outlineColor : 0x202020;
        int op = this.opacity << 24 | 0xFFFFFF;
        class_327.class_6415 displayMode = this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33995;
        float f = vertexOffset = this.outline ? -5.0E-4f : 0.0f;
        if (bg != 0) {
            int offset = this.alignment.apply(this.cacheWidth);
            float x1 = -1 - offset;
            float x2 = this.cacheWidth - offset;
            class_4588 vertexConsumer = buffer.getBuffer(this.seeThrough ? class_1921.method_49046() : class_1921.method_49045());
            vertexConsumer.method_22918(matrix, x1, -1.0f, vertexOffset).method_39415(bg).method_22916(l).method_1344();
            vertexConsumer.method_22918(matrix, x1, (float)this.cacheHeight, vertexOffset).method_39415(bg).method_22916(l).method_1344();
            vertexConsumer.method_22918(matrix, x2, (float)this.cacheHeight, vertexOffset).method_39415(bg).method_22916(l).method_1344();
            vertexConsumer.method_22918(matrix, x2, -1.0f, vertexOffset).method_39415(bg).method_22916(l).method_1344();
        }
        int i = 0;
        int j = 0;
        while (i < this.text.size()) {
            class_2561 text = this.text.get(i);
            int x = -this.alignment.apply(font, (class_5348)text);
            if (this.outline) {
                font.method_37296(text.method_30937(), (float)x, (float)j, -1, out, matrix, buffer, l);
                if (this.seeThrough) {
                    font.method_30882(text, (float)x, (float)j, op, this.shadow, matrix, buffer, displayMode, 0, l);
                }
            } else {
                font.method_30882(text, (float)x, (float)j, op, this.shadow, matrix, buffer, displayMode, 0, l);
            }
            ++i;
            Objects.requireNonNull(font);
            j += 9 + 1;
        }
    }

    @Override
    public int getComplexity() {
        return this.cachedComplexity;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.text != null && this.text.size() != 0;
    }

    private void updateText() {
        if (this.textCached == null) {
            this.text = null;
            return;
        }
        class_2561 component = TextUtils.tryParseJson(this.textCached);
        component = Badges.noBadges4U(component);
        component = Emojis.applyEmojis(component);
        component = Emojis.removeBlacklistedEmojis(component);
        this.text = TextUtils.formatInBounds((class_5348)component, class_310.method_1551().field_1772, this.width, this.wrap);
        class_327 font = class_310.method_1551().field_1772;
        this.cacheWidth = TextUtils.getWidth(this.text, font);
        int n = this.text.size();
        Objects.requireNonNull(font);
        this.cacheHeight = n * 9;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_text")
    public String getText() {
        return this.textCached;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, aliases={"text"}, value="text_task.set_text")
    public TextTask setText(String text) {
        this.textCached = text;
        this.updateText();
        if (text != null) {
            this.cachedComplexity = text.length() + 1;
        }
        return this;
    }

    @LuaWhitelist
    public TextTask text(String text) {
        return this.setText(text);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_alignment")
    public String getAlignment() {
        return this.alignment.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"alignment"})}, aliases={"alignment"}, value="text_task.set_alignment")
    public TextTask setAlignment(@LuaNotNil String alignment) {
        try {
            this.alignment = TextUtils.Alignment.valueOf(alignment.toUpperCase());
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid alignment type \"" + alignment + "\"");
        }
        return this;
    }

    @LuaWhitelist
    public TextTask alignment(@LuaNotNil String alignment) {
        return this.setAlignment(alignment);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.has_shadow")
    public boolean hasShadow() {
        return this.shadow;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"shadow"})}, aliases={"shadow"}, value="text_task.set_shadow")
    public TextTask setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    @LuaWhitelist
    public TextTask shadow(boolean shadow) {
        return this.setShadow(shadow);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.has_outline")
    public boolean hasOutline() {
        return this.outline;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"outline"})}, aliases={"outline"}, value="text_task.set_outline")
    public TextTask setOutline(boolean outline) {
        this.outline = outline;
        return this;
    }

    @LuaWhitelist
    public TextTask outline(boolean outline) {
        return this.setOutline(outline);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_outline_color")
    public FiguraVec3 getOutlineColor() {
        return ColorUtils.intToRGB(this.outlineColor);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"outlineColor"}, value="text_task.set_outline_color")
    public TextTask setOutlineColor(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setOutlineColor", x, y, z);
        this.outlineColor = ColorUtils.rgbToInt(vec);
        return this;
    }

    @LuaWhitelist
    public TextTask outlineColor(Object x, Double y, Double z) {
        return this.setOutlineColor(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_width")
    public int getWidth() {
        return this.width;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class}, argumentNames={"width"})}, aliases={"width"}, value="text_task.set_width")
    public TextTask setWidth(int width) {
        this.width = width;
        this.updateText();
        return this;
    }

    @LuaWhitelist
    public TextTask width(int width) {
        return this.setWidth(width);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.has_wrap")
    public boolean HasWrap() {
        return this.wrap;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"wrap"})}, aliases={"wrap"}, value="text_task.set_wrap")
    public TextTask setWrap(boolean wrap) {
        this.wrap = wrap;
        this.updateText();
        return this;
    }

    @LuaWhitelist
    public TextTask wrap(boolean wrap) {
        return this.setWrap(wrap);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.is_see_through")
    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"seeThrough"})}, aliases={"seeThrough"}, value="text_task.set_see_through")
    public TextTask setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        return this;
    }

    @LuaWhitelist
    public TextTask seeThrough(boolean seeThrough) {
        return this.setSeeThrough(seeThrough);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.has_background")
    public boolean hasBackground() {
        return this.background;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"background"})}, aliases={"background"}, value="text_task.set_background")
    public TextTask setBackground(boolean background) {
        this.background = background;
        return this;
    }

    @LuaWhitelist
    public TextTask background(boolean background) {
        return this.setBackground(background);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_background_color")
    public FiguraVec4 getBackgroundColor() {
        return this.backgroundColor == null ? null : ColorUtils.intToARGB(this.backgroundColor);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec4.class}, argumentNames={"rgba"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b", "a"})}, aliases={"backgroundColor"}, value="text_task.set_background_color")
    public TextTask setBackgroundColor(Object r, Double g, Double b, Double a) {
        FiguraVec4 vec = LuaUtils.parseVec4("setBackgroundColor", r, g, b, a, 0.0, 0.0, 0.0, class_310.method_1551().field_1690.method_19343(0.25f));
        this.backgroundColor = ColorUtils.rgbaToIntARGB(vec);
        return this;
    }

    @LuaWhitelist
    public TextTask backgroundColor(Object r, Double g, Double b, Double a) {
        return this.setBackgroundColor(r, g, b, a);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="text_task.get_opacity")
    public float getOpacity() {
        return (float)this.opacity / 255.0f;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"opacity"})}, aliases={"opacity"}, value="text_task.set_opacity")
    public TextTask setOpacity(float opacity) {
        this.opacity = (int)(opacity * 255.0f);
        return this;
    }

    @LuaWhitelist
    public TextTask opacity(float opacity) {
        return this.setOpacity(opacity);
    }

    @Override
    public String toString() {
        return this.name + " (Text Render Task)";
    }
}

