/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.model.rendering;

import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.lua.api.ClientAPI;
import fabric.org.figuramc.figura.math.matrix.FiguraMat3;
import fabric.org.figuramc.figura.math.matrix.FiguraMat4;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.model.FiguraModelPart;
import fabric.org.figuramc.figura.model.FiguraModelPartReader;
import fabric.org.figuramc.figura.model.ParentType;
import fabric.org.figuramc.figura.model.PartCustomization;
import fabric.org.figuramc.figura.model.rendering.AvatarRenderer;
import fabric.org.figuramc.figura.model.rendering.EntityRenderMode;
import fabric.org.figuramc.figura.model.rendering.Vertex;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import fabric.org.figuramc.figura.model.rendering.texture.RenderTypes;
import fabric.org.figuramc.figura.model.rendertasks.RenderTask;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_765;

public class ImmediateAvatarRenderer
extends AvatarRenderer {
    protected final PartCustomization.PartCustomizationStack customizationStack = new PartCustomization.PartCustomizationStack();
    public static final FiguraMat4 VIEW_TO_WORLD_MATRIX = FiguraMat4.of();
    private static final PartCustomization pivotOffsetter = new PartCustomization();
    protected static final VertexBuffer VERTEX_BUFFER = new VertexBuffer();
    private static final FiguraVec4 pos = FiguraVec4.of();
    private static final FiguraVec3 normal = FiguraVec3.of();
    private static final FiguraVec3 uv = FiguraVec3.of(0.0, 0.0, 1.0);

    public ImmediateAvatarRenderer(Avatar avatar) {
        super(avatar);
        this.root = FiguraModelPartReader.read(avatar, avatar.nbt.method_10562("models"), this.textureSets, false);
        this.sortParts();
    }

    public void checkEmpty() {
        if (!this.customizationStack.isEmpty()) {
            throw new IllegalStateException("Customization stack not empty!");
        }
    }

    @Override
    public int render() {
        return this.commonRender(1.5);
    }

    @Override
    public int renderSpecialParts() {
        return this.commonRender(0.0);
    }

    @Override
    public void updateMatrices() {
        this.isRendering = true;
        PartCustomization customization = this.setupRootCustomization(1.5);
        this.customizationStack.push(customization);
        VIEW_TO_WORLD_MATRIX.set(AvatarRenderer.worldToViewMatrix().invert());
        this.calculatePartMatrices(this.root);
        this.customizationStack.pop();
        this.checkEmpty();
        this.isRendering = false;
    }

    protected int commonRender(double vertOffset) {
        this.isRendering = true;
        int irisConfig = UIHelper.paperdoll || !ClientAPI.hasIris() ? 0 : (Integer)Configs.IRIS_COMPATIBILITY_FIX.value;
        this.doIrisEmissiveFix = irisConfig >= 2 && ClientAPI.hasIrisShader() || this.avatar.renderMode != EntityRenderMode.RENDER && this.avatar.renderMode != EntityRenderMode.WORLD;
        this.offsetRenderLayers = irisConfig >= 1;
        for (FiguraTextureSet set : this.textureSets) {
            set.uploadIfNeeded();
        }
        for (FiguraTexture texture : this.customTextures.values()) {
            texture.uploadIfDirty();
        }
        int config = (Integer)Configs.RENDER_DEBUG_PARTS_PIVOT.value;
        shouldRenderPivots = !class_310.method_1551().method_1561().method_3958() || !this.avatar.isHost && config < 2 ? 0 : config;
        if (this.allowMatrixUpdate) {
            VIEW_TO_WORLD_MATRIX.set(AvatarRenderer.worldToViewMatrix().invert());
        }
        int prev = this.avatar.complexity.remaining;
        int[] remainingComplexity = new int[]{prev};
        if (this.root.customization.visible == null || this.root.customization.visible.booleanValue()) {
            if (this.currentFilterScheme.parentType.isSeparate) {
                List parts = (List)this.separatedParts.get((Object)this.currentFilterScheme.parentType);
                if (parts != null) {
                    boolean renderLayer;
                    boolean bl = renderLayer = !this.currentFilterScheme.parentType.isRenderLayer;
                    if (renderLayer) {
                        PartCustomization customization = this.setupRootCustomization(vertOffset);
                        this.customizationStack.push(customization);
                        this.customizationStack.push(this.root.customization);
                    }
                    for (FiguraModelPart part : parts) {
                        boolean saved;
                        if (this.currentFilterScheme.parentType == ParentType.Item && part != this.itemToRender) continue;
                        boolean bl2 = saved = part.savedCustomization != null;
                        if (saved) {
                            this.customizationStack.push(part.savedCustomization);
                            part.savedCustomization = null;
                        }
                        this.renderPart(part, remainingComplexity, this.currentFilterScheme.initialValue);
                        if (!saved) continue;
                        this.customizationStack.pop();
                    }
                    if (renderLayer) {
                        this.customizationStack.pop();
                        this.customizationStack.pop();
                    }
                }
            } else {
                PartCustomization customization = this.setupRootCustomization(vertOffset);
                this.customizationStack.push(customization);
                this.renderPart(this.root, remainingComplexity, this.currentFilterScheme.initialValue);
                this.customizationStack.pop();
            }
            FiguraMod.pushProfiler("draw");
            FiguraMod.pushProfiler("primary");
            VERTEX_BUFFER.consume(true, this.bufferSource);
            FiguraMod.popPushProfiler("secondary");
            VERTEX_BUFFER.consume(false, this.bufferSource);
            FiguraMod.popProfiler(2);
            this.checkEmpty();
        }
        this.isRendering = false;
        if (this.dirty) {
            this.clean();
        }
        return prev - Math.max(remainingComplexity[0], 0);
    }

    protected PartCustomization setupRootCustomization(double vertOffset) {
        PartCustomization customization = new PartCustomization();
        customization.setPrimaryRenderType(RenderTypes.TRANSLUCENT);
        customization.setSecondaryRenderType(RenderTypes.EMISSIVE);
        double s = 0.0625;
        customization.positionMatrix.scale(s, s, s);
        customization.positionMatrix.rotateZ(180.0);
        customization.positionMatrix.translate(0.0, vertOffset, 0.0);
        customization.normalMatrix.rotateZ(180.0);
        customization.positionMatrix.multiply(this.posMat);
        customization.normalMatrix.multiply(this.normalMat);
        customization.light = this.light;
        customization.alpha = Float.valueOf(this.alpha);
        customization.overlay = this.overlay;
        customization.primaryTexture = Pair.of((Object)((Object)FiguraTextureSet.OverrideType.PRIMARY), null);
        customization.secondaryTexture = Pair.of((Object)((Object)FiguraTextureSet.OverrideType.SECONDARY), null);
        return customization;
    }

    protected boolean renderPart(FiguraModelPart part, int[] remainingComplexity, boolean prevPredicate) {
        boolean voidMatrices;
        FiguraMod.pushProfiler(part.name);
        PartCustomization custom = part.customization;
        FiguraMod.pushProfiler("predicate");
        Boolean thisPassedPredicate = this.currentFilterScheme.test(part.parentType, prevPredicate);
        if (thisPassedPredicate == null || custom.visible != null && !custom.visible.booleanValue()) {
            if (part.parentType.isRenderLayer) {
                part.savedCustomization = this.customizationStack.peek();
            }
            FiguraMod.popProfiler(2);
            return true;
        }
        FiguraMod.popPushProfiler("copyVanillaPart");
        part.applyVanillaTransforms(this.vanillaModelData);
        part.applyExtraTransforms(this.customizationStack.peek());
        FiguraMod.popPushProfiler("checkVanillaVisible");
        if (!this.ignoreVanillaVisibility && custom.vanillaVisible != null && !custom.vanillaVisible.booleanValue()) {
            FiguraMod.popPushProfiler("removeVanillaTransforms");
            part.resetVanillaTransforms();
            FiguraMod.popProfiler(2);
            return true;
        }
        if (part.preRender != null) {
            FiguraMod.popPushProfiler("preRenderFunction");
            this.avatar.run(part.preRender, this.avatar.render, Float.valueOf(this.tickDelta), this.avatar.renderMode.name(), part);
        }
        FiguraMod.popPushProfiler("calculatePartMatrices");
        custom.recalculate();
        FiguraMat4 positionCopy = null;
        FiguraMat3 normalCopy = null;
        boolean bl = voidMatrices = !this.allowHiddenTransforms && !prevPredicate;
        if (voidMatrices) {
            FiguraMod.popPushProfiler("clearMatrices");
            positionCopy = custom.positionMatrix.copy();
            normalCopy = custom.normalMatrix.copy();
            custom.positionMatrix.reset();
            custom.normalMatrix.reset();
        }
        FiguraMod.popPushProfiler("pushCustomizationStack");
        this.customizationStack.push(custom);
        if (voidMatrices) {
            FiguraMod.popPushProfiler("restoreMatrices");
            custom.positionMatrix.set(positionCopy);
            custom.normalMatrix.set(normalCopy);
        }
        if (thisPassedPredicate.booleanValue()) {
            class_638 l;
            FiguraMod.popPushProfiler("worldMatrices");
            if (this.allowMatrixUpdate) {
                FiguraMat4 mat = this.partToWorldMatrices(custom);
                part.savedPartToWorldMat.set(mat);
            }
            FiguraMod.popPushProfiler("calculateLight");
            if (custom.light != null) {
                this.updateLight = false;
            } else if (this.updateLight && (l = class_310.method_1551().field_1687) != null) {
                FiguraVec3 pos = part.savedPartToWorldMat.apply(0.0, 0.0, 0.0);
                int block = l.method_8314(class_1944.field_9282, pos.asBlockPos());
                int sky = l.method_8314(class_1944.field_9284, pos.asBlockPos());
                this.customizationStack.peek().light = class_765.method_23687((int)block, (int)sky);
            }
        }
        if (part.midRender != null) {
            FiguraMod.popPushProfiler("midRenderFunction");
            this.avatar.run(part.midRender, this.avatar.render, Float.valueOf(this.tickDelta), this.avatar.renderMode.name(), part);
        }
        FiguraMod.popPushProfiler("pushVertices");
        boolean breakRender = thisPassedPredicate != false && !part.pushVerticesImmediate(this, remainingComplexity);
        FiguraMod.popPushProfiler("extras");
        if (!breakRender && thisPassedPredicate.booleanValue()) {
            boolean renderPivotParts;
            boolean renderPivot = shouldRenderPivots > 0;
            boolean renderTasks = !part.renderTasks.isEmpty();
            boolean bl2 = renderPivotParts = part.parentType.isPivot && this.allowPivotParts;
            if (renderPivot || renderTasks || renderPivotParts) {
                FiguraMod.pushProfiler("fixMatricesPivot");
                FiguraVec3 pivot = custom.getPivot();
                pivotOffsetter.setPos(pivot);
                pivotOffsetter.recalculate();
                this.customizationStack.push(pivotOffsetter);
                PartCustomization peek = this.customizationStack.peek();
                if (renderPivot) {
                    FiguraMod.popPushProfiler("renderPivotCube");
                    this.renderPivot(part, peek);
                }
                if (renderTasks) {
                    FiguraMod.popPushProfiler("renderTasks");
                    int light = peek.light;
                    int overlay = peek.overlay;
                    this.allowSkullRendering = false;
                    for (RenderTask task : part.renderTasks.values()) {
                        if (!task.shouldRender()) continue;
                        int neededComplexity = task.getComplexity();
                        if (neededComplexity > remainingComplexity[0]) break;
                        FiguraMod.pushProfiler(task.getName());
                        task.render(this.customizationStack, this.bufferSource, light, overlay);
                        remainingComplexity[0] = remainingComplexity[0] - neededComplexity;
                        FiguraMod.popProfiler();
                    }
                    this.allowSkullRendering = true;
                }
                if (renderPivotParts && part.parentType.isPivot) {
                    FiguraMod.popPushProfiler("savePivotParts");
                    this.savePivotTransform(part.parentType, peek);
                }
                this.customizationStack.pop();
                FiguraMod.popProfiler();
            }
        }
        FiguraMod.popPushProfiler("children");
        for (FiguraModelPart child : List.copyOf(part.children)) {
            if (this.renderPart(child, remainingComplexity, thisPassedPredicate)) continue;
            breakRender = true;
            break;
        }
        FiguraMod.popPushProfiler("removeVanillaTransforms");
        part.resetVanillaTransforms();
        if (part.postRender != null) {
            FiguraMod.popPushProfiler("postRenderFunction");
            this.avatar.run(part.postRender, this.avatar.render, Float.valueOf(this.tickDelta), this.avatar.renderMode.name(), part);
        }
        this.customizationStack.pop();
        FiguraMod.popProfiler(2);
        return !breakRender;
    }

    protected void renderPivot(FiguraModelPart part, PartCustomization customization) {
        boolean group = part.customization.partType == PartCustomization.PartType.GROUP;
        FiguraVec3 color = group ? ColorUtils.Colors.BLUE.vec : ColorUtils.Colors.AWESOME_BLUE.vec;
        double boxSize = group ? 0.0625 : 0.03125;
        class_4587 stack = customization.copyIntoGlobalPoseStack();
        class_761.method_22980((class_4587)stack, (class_4588)this.bufferSource.getBuffer((class_1921)class_1921.field_21695), (double)(-(boxSize /= Math.max(Math.cbrt(part.savedPartToWorldMat.det()), 0.02))), (double)(-boxSize), (double)(-boxSize), (double)boxSize, (double)boxSize, (double)boxSize, (float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)1.0f);
    }

    protected void savePivotTransform(ParentType parentType, PartCustomization customization) {
        FiguraMat4 currentPosMat = customization.getPositionMatrix();
        FiguraMat3 currentNormalMat = customization.getNormalMatrix();
        ConcurrentLinkedQueue queue = this.pivotCustomizations.computeIfAbsent(parentType, p -> new ConcurrentLinkedQueue());
        queue.add(new Pair((Object)currentPosMat, (Object)currentNormalMat));
    }

    protected FiguraMat4 partToWorldMatrices(PartCustomization cust) {
        FiguraMat4 customizePeek = this.customizationStack.peek().positionMatrix.copy();
        customizePeek.multiply(VIEW_TO_WORLD_MATRIX);
        FiguraVec3 piv = cust.getPivot();
        FiguraMat4 translation = FiguraMat4.of();
        translation.translate(piv);
        customizePeek.rightMultiply(translation);
        return customizePeek;
    }

    protected void calculatePartMatrices(FiguraModelPart part) {
        FiguraMod.pushProfiler(part.name);
        PartCustomization custom = part.customization;
        FiguraMod.pushProfiler("predicate");
        Boolean thisPassedPredicate = this.currentFilterScheme.test(part.parentType, true);
        if (thisPassedPredicate == null) {
            FiguraMod.popProfiler(2);
            return;
        }
        FiguraMod.popPushProfiler("copyVanillaPart");
        part.applyVanillaTransforms(this.vanillaModelData);
        part.applyExtraTransforms(this.customizationStack.peek());
        FiguraMod.popPushProfiler("calculatePartMatrices");
        custom.recalculate();
        FiguraMod.popPushProfiler("applyOnStack");
        this.customizationStack.push(custom);
        if (thisPassedPredicate.booleanValue()) {
            FiguraMod.popPushProfiler("worldMatrices");
            FiguraMat4 mat = this.partToWorldMatrices(custom);
            part.savedPartToWorldMat.set(mat);
        }
        FiguraMod.popPushProfiler("children");
        for (FiguraModelPart child : part.children) {
            this.calculatePartMatrices(child);
        }
        part.resetVanillaTransforms();
        this.customizationStack.pop();
        FiguraMod.popProfiler(2);
    }

    public void pushFaces(int faceCount, int[] remainingComplexity, FiguraTextureSet textureSet, List<Vertex> vertices) {
        if (faceCount == 0 || vertices.isEmpty()) {
            return;
        }
        PartCustomization customization = this.customizationStack.peek();
        VertexData primary = this.getTexture(customization, textureSet, true);
        VertexData secondary = this.getTexture(customization, textureSet, false);
        if (primary.renderType == null && secondary.renderType == null) {
            remainingComplexity[0] = remainingComplexity[0] + faceCount;
            return;
        }
        if (primary.renderType != null) {
            this.pushToBuffer(faceCount, primary, customization, textureSet, vertices);
        }
        if (secondary.renderType != null) {
            this.pushToBuffer(faceCount, secondary, customization, textureSet, vertices);
        }
    }

    private VertexData getTexture(PartCustomization customization, FiguraTextureSet textureSet, boolean primary) {
        RenderTypes types = primary ? customization.getPrimaryRenderType() : customization.getSecondaryRenderType();
        Pair<FiguraTextureSet.OverrideType, Object> texture = primary ? customization.primaryTexture : customization.secondaryTexture;
        VertexData ret = new VertexData();
        if (types == RenderTypes.NONE) {
            return ret;
        }
        class_2960 id = textureSet.getOverrideTexture(this.avatar.owner, texture);
        ret.color = primary ? customization.color : customization.color2;
        ret.primary = primary;
        if (id != null) {
            if (this.translucent) {
                ret.renderType = class_1921.method_29379((class_2960)id);
                return ret;
            }
            if (this.glowing) {
                ret.renderType = class_1921.method_23287((class_2960)id);
                return ret;
            }
        }
        if (types == null) {
            return ret;
        }
        if (this.offsetRenderLayers && !primary && types.isOffset()) {
            ret.vertexOffset = -5.0E-4f;
        }
        if (this.doIrisEmissiveFix && types == RenderTypes.EMISSIVE) {
            ret.fullBright = true;
            ret.renderType = RenderTypes.TRANSLUCENT_CULL.get(id);
        } else {
            ret.renderType = types.get(id);
        }
        return ret;
    }

    private void pushToBuffer(int faceCount, VertexData vertexData, PartCustomization customization, FiguraTextureSet textureSet, List<Vertex> vertices) {
        int vertCount = faceCount * 4;
        FiguraVec3 uvFixer = FiguraVec3.of();
        uvFixer.set(textureSet.getWidth(), (double)textureSet.getHeight(), 1.0);
        int overlay = customization.overlay;
        int light = vertexData.fullBright ? 0xF000F0 : customization.light;
        VERTEX_BUFFER.getBufferFor(vertexData.renderType, vertexData.primary, vertexConsumer -> {
            for (int i = 0; i < vertCount; ++i) {
                Vertex vertex = (Vertex)vertices.get(i);
                pos.set(vertex.x, (double)vertex.y, (double)vertex.z, 1.0);
                pos.transform(customization.positionMatrix);
                pos.add(pos.normalized().scale(vertexData.vertexOffset));
                normal.set(vertex.nx, (double)vertex.ny, (double)vertex.nz);
                normal.transform(customization.normalMatrix);
                uv.set(vertex.u, (double)vertex.v, 1.0);
                uv.divide(uvFixer);
                uv.transform(customization.uvMatrix);
                vertexConsumer.method_22912(ImmediateAvatarRenderer.pos.x, ImmediateAvatarRenderer.pos.y, ImmediateAvatarRenderer.pos.z).method_22915((float)vertexData.color.x, (float)vertexData.color.y, (float)vertexData.color.z, customization.alpha.floatValue()).method_22913((float)ImmediateAvatarRenderer.uv.x, (float)ImmediateAvatarRenderer.uv.y).method_22922(overlay).method_22916(light).method_22914((float)ImmediateAvatarRenderer.normal.x, (float)ImmediateAvatarRenderer.normal.y, (float)ImmediateAvatarRenderer.normal.z).method_1344();
            }
        });
    }

    private static class VertexBuffer {
        private final HashMap<class_1921, List<Consumer<class_4588>>> primaryBuffers = new LinkedHashMap<class_1921, List<Consumer<class_4588>>>();
        private final HashMap<class_1921, List<Consumer<class_4588>>> secondaryBuffers = new LinkedHashMap<class_1921, List<Consumer<class_4588>>>();

        private VertexBuffer() {
        }

        public void getBufferFor(class_1921 renderType, boolean primary, Consumer<class_4588> consumer) {
            HashMap<class_1921, List<Consumer<class_4588>>> buffer = primary ? this.primaryBuffers : this.secondaryBuffers;
            List list = buffer.computeIfAbsent(renderType, renderType1 -> new ArrayList());
            list.add(consumer);
        }

        public void consume(boolean primary, class_4597 bufferSource) {
            HashMap<class_1921, List<Consumer<class_4588>>> map = primary ? this.primaryBuffers : this.secondaryBuffers;
            for (Map.Entry<class_1921, List<Consumer<class_4588>>> entry : map.entrySet()) {
                class_4588 vertexConsumer = bufferSource.getBuffer(entry.getKey());
                List<Consumer<class_4588>> consumers = entry.getValue();
                for (Consumer<class_4588> consumer : consumers) {
                    consumer.accept(vertexConsumer);
                }
            }
            map.clear();
        }
    }

    private static class VertexData {
        public class_1921 renderType;
        public boolean fullBright;
        public float vertexOffset;
        public FiguraVec3 color;
        public boolean primary;

        private VertexData() {
        }
    }
}

