/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.mixin.render.renderers;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.avatar.Badges;
import fabric.org.figuramc.figura.compat.SimpleVCCompat;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.lua.api.ClientAPI;
import fabric.org.figuramc.figura.lua.api.nameplate.EntityNameplateCustomization;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.TextUtils;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class PlayerRendererMixin
extends class_922<class_742, class_591<class_742>> {
    @Unique
    private Avatar avatar;

    public PlayerRendererMixin(class_5617.class_5618 context, class_591<class_742> entityModel, float shadowRadius) {
        super(context, entityModel, shadowRadius);
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderNameTag(class_742 player, class_2561 text, class_4587 stack, class_4597 multiBufferSource, int light, CallbackInfo ci) {
        float y;
        float x;
        class_269 scoreboard;
        class_266 scoreboardObjective;
        Matrix4f matrix4f;
        boolean hasCustom;
        int config = (Integer)Configs.ENTITY_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic || this.field_4676.method_23168((class_1297)player) > 4096.0) {
            return;
        }
        Avatar avatar = AvatarManager.getAvatarForPlayer(player.method_5667());
        EntityNameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.ENTITY;
        boolean bl = hasCustom = custom != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1;
        if (hasCustom && !custom.visible) {
            ci.cancel();
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(player.method_5477().getString());
        FiguraMod.pushProfiler("nameplate");
        stack.method_22903();
        FiguraMod.pushProfiler("pivot");
        FiguraVec3 pivot = hasCustom && custom.getPivot() != null ? custom.getPivot() : FiguraVec3.of(0.0, player.method_17682() + 0.5f, 0.0);
        stack.method_22904(pivot.x, pivot.y, pivot.z);
        stack.method_22907(this.field_4676.method_24197());
        FiguraMod.popPushProfiler("position");
        if (hasCustom && custom.getPos() != null) {
            FiguraVec3 pos = custom.getPos();
            stack.method_22904(pos.x, pos.y, pos.z);
        }
        FiguraMod.popPushProfiler("scale");
        float scale = 0.025f;
        FiguraVec3 scaleVec = FiguraVec3.of(-scale, -scale, scale);
        if (hasCustom && custom.getScale() != null) {
            scaleVec.multiply(custom.getScale());
        }
        stack.method_22905((float)scaleVec.x, (float)scaleVec.y, (float)scaleVec.z);
        class_5250 name = class_2561.method_43470((String)player.method_5477().getString());
        FiguraMod.popPushProfiler("text");
        class_5250 replacement = hasCustom && custom.getJson() != null ? custom.getJson().method_27661() : name;
        replacement = TextUtils.replaceInText((class_5348)replacement, "\\$\\{name\\}", name);
        FiguraMod.popPushProfiler("badges");
        replacement = Badges.appendBadges((class_2561)replacement, player.method_5667(), config > 1);
        FiguraMod.popPushProfiler("applyName");
        text = TextUtils.replaceInText((class_5348)text, "\\b" + Pattern.quote(player.method_5477().getString()) + "\\b", replacement);
        FiguraMod.popPushProfiler("colors");
        boolean notSneaking = !player.method_21751();
        boolean deadmau = text.getString().equals("deadmau5");
        int bgColor = hasCustom && custom.background != null ? custom.background : (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
        int outlineColor = hasCustom && custom.outlineColor != null ? custom.outlineColor : 0x202020;
        boolean outline = hasCustom && custom.outline;
        boolean shadow = hasCustom && custom.shadow;
        light = hasCustom && custom.light != null ? custom.light : light;
        class_327 font = this.method_3932();
        Matrix4f textMatrix = matrix4f = stack.method_23760().method_23761();
        if (shadow) {
            stack.method_22903();
            stack.method_22905(1.0f, 1.0f, -1.0f);
            textMatrix = stack.method_23760().method_23761();
            stack.method_22909();
        }
        FiguraMod.popPushProfiler("render");
        FiguraMod.pushProfiler("scoreboard");
        boolean hasScore = false;
        if (this.field_4676.method_23168((class_1297)player) < 100.0 && (scoreboardObjective = (scoreboard = player.method_7327()).method_1189(2)) != null) {
            hasScore = true;
            class_267 score = scoreboard.method_1180(player.method_5820(), scoreboardObjective);
            class_5250 text1 = class_2561.method_43470((String)Integer.toString(score.method_1126())).method_27693(" ").method_10852(scoreboardObjective.method_1114());
            x = (float)(-font.method_27525((class_5348)text1)) / 2.0f;
            y = deadmau ? -10.0f : 0.0f;
            font.method_30882((class_2561)text1, x, y, 0x20FFFFFF, false, matrix4f, multiBufferSource, notSneaking ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, bgColor, light);
            if (notSneaking) {
                if (outline) {
                    font.method_37296(text1.method_30937(), x, y, -1, outlineColor, matrix4f, multiBufferSource, light);
                } else {
                    font.method_30882((class_2561)text1, x, y, -1, shadow, textMatrix, multiBufferSource, class_327.class_6415.field_33993, 0, light);
                }
            }
        }
        FiguraMod.popPushProfiler("name");
        List<class_2561> textList = TextUtils.splitText((class_5348)text, "\n");
        for (int i = 0; i < textList.size(); ++i) {
            class_2561 text1 = textList.get(i);
            if (text1.getString().isEmpty()) continue;
            int line = i - textList.size() + (hasScore ? 0 : 1);
            x = (float)(-font.method_27525((class_5348)text1)) / 2.0f;
            float f = deadmau ? -10.0f : 0.0f;
            Objects.requireNonNull(font);
            y = f + (float)((9 + 1) * line);
            font.method_30882(text1, x, y, 0x20FFFFFF, false, matrix4f, multiBufferSource, notSneaking ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, bgColor, light);
            if (notSneaking) {
                if (outline) {
                    font.method_37296(text1.method_30937(), x, y, -1, outlineColor, matrix4f, multiBufferSource, light);
                } else {
                    font.method_30882(text1, x, y, -1, shadow, textMatrix, multiBufferSource, class_327.class_6415.field_33993, 0, light);
                }
            }
            if (!ClientAPI.isModLoaded("voicechat") || textList.get(i) != textList.get(textList.size() - 1)) continue;
            SimpleVCCompat.renderSimpleVCIcon((class_1297)player, text1, stack, multiBufferSource, light);
        }
        FiguraMod.popProfiler(5);
        stack.method_22909();
        ci.cancel();
    }

    @Inject(at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")}, method={"renderHand"})
    private void onRenderHand(class_4587 stack, class_4597 multiBufferSource, int light, class_742 player, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        this.avatar = AvatarManager.getAvatarForPlayer(player.method_5667());
        if (this.avatar != null && this.avatar.luaRuntime != null) {
            VanillaGroupPart part = this.avatar.luaRuntime.vanilla_model.PLAYER;
            class_591 model = (class_591)this.method_4038();
            ((VanillaPart)part).save((class_583<?>)model);
            if (this.avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform((class_583<?>)model);
                ((VanillaPart)part).posTransform((class_583<?>)model);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderHand"})
    private void postRenderHand(class_4587 stack, class_4597 multiBufferSource, int light, class_742 player, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        if (this.avatar == null) {
            return;
        }
        float delta = class_310.method_1551().method_1488();
        this.avatar.firstPersonRender(stack, multiBufferSource, (class_1657)player, (class_1007)this, arm, light, delta);
        if (this.avatar.luaRuntime != null) {
            this.avatar.luaRuntime.vanilla_model.PLAYER.restore(this.method_4038());
        }
        this.avatar = null;
    }
}

