/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.mixin.render.renderers;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.gui.PopupMenu;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaGroupPart;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import fabric.org.figuramc.figura.math.matrix.FiguraMat4;
import fabric.org.figuramc.figura.model.rendering.PartFilterScheme;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.RenderUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_922.class})
public abstract class LivingEntityRendererMixin<T extends class_1309, M extends class_583<T>>
extends class_897<T>
implements class_3883<T, M> {
    @Shadow
    @Final
    protected List<class_3887<T, M>> field_4738;
    @Unique
    private Avatar currentAvatar;
    @Unique
    private Matrix4f lastPose;

    protected LivingEntityRendererMixin(class_5617.class_5618 context) {
        super(context);
    }

    @Shadow
    protected abstract boolean method_4056(T var1);

    @Shadow
    public static int method_23622(class_1309 entity, float whiteOverlayProgress) {
        return 0;
    }

    @Shadow
    protected abstract float method_23185(T var1, float var2);

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void onRender(T livingEntity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo ci) {
        this.currentAvatar = AvatarManager.getAvatar(livingEntity);
        if (this.currentAvatar == null) {
            return;
        }
        this.lastPose = poseStack.method_23760().method_23761();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void preRender(T entity, float yaw, float delta, class_4587 poseStack, class_4597 bufferSource, int light, CallbackInfo ci) {
        boolean showBody;
        if (this.currentAvatar == null) {
            return;
        }
        if (Avatar.firstPerson) {
            this.currentAvatar.updateMatrices((class_922)this, poseStack);
            this.currentAvatar = null;
            this.lastPose = null;
            poseStack.method_22909();
            ci.cancel();
            return;
        }
        if (this.currentAvatar.luaRuntime != null) {
            VanillaGroupPart part = this.currentAvatar.luaRuntime.vanilla_model.PLAYER;
            class_583 model = this.method_4038();
            ((VanillaPart)part).save(model);
            if (this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
                ((VanillaPart)part).preTransform(model);
            }
        }
        boolean translucent = !(showBody = this.method_4056(entity)) && class_310.method_1551().field_1724 != null && !entity.method_5756((class_1657)class_310.method_1551().field_1724);
        boolean glowing = !showBody && class_310.method_1551().method_27022(entity);
        boolean invisible = !translucent && !showBody && !glowing;
        PartFilterScheme filter = invisible ? PartFilterScheme.PIVOTS : PartFilterScheme.MODEL;
        int overlay = LivingEntityRendererMixin.method_23622(entity, this.method_23185(entity, delta));
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this.currentAvatar);
        FiguraMod.pushProfiler("calculateMatrix");
        Matrix4f diff = new Matrix4f((Matrix4fc)this.lastPose).invert().mul((Matrix4fc)poseStack.method_23760().method_23761());
        FiguraMat4 poseMatrix = new FiguraMat4().set(diff);
        FiguraMod.popPushProfiler("renderEvent");
        this.currentAvatar.renderEvent(delta, poseMatrix);
        FiguraMod.popPushProfiler("render");
        this.currentAvatar.render((class_1297)entity, yaw, delta, translucent ? 0.15f : 1.0f, poseStack, bufferSource, light, overlay, (class_922<?, ?>)((class_922)this), filter, translucent, glowing);
        FiguraMod.popPushProfiler("postRenderEvent");
        this.currentAvatar.postRenderEvent(delta, poseMatrix);
        FiguraMod.popProfiler(3);
        if (this.currentAvatar.luaRuntime != null && this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
            this.currentAvatar.luaRuntime.vanilla_model.PLAYER.posTransform(this.method_4038());
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")}, method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"})
    private void endRender(T entity, float yaw, float delta, class_4587 matrices, class_4597 bufferSource, int light, CallbackInfo ci) {
        if (this.currentAvatar == null) {
            return;
        }
        if (this.currentAvatar.luaRuntime != null && this.currentAvatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) == 1) {
            this.currentAvatar.luaRuntime.vanilla_model.PLAYER.restore(this.method_4038());
        }
        this.currentAvatar = null;
        this.lastPose = null;
    }

    @Inject(method={"shouldShowName(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldShowName(T livingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (UIHelper.paperdoll) {
            cir.setReturnValue((Object)((Boolean)Configs.PREVIEW_NAMEPLATE.value));
        } else if (!class_310.method_1498() || livingEntity.method_5667().equals(PopupMenu.getEntityId())) {
            cir.setReturnValue((Object)false);
        } else if (!AvatarManager.panic) {
            if (((Boolean)Configs.SELF_NAMEPLATE.value).booleanValue() && livingEntity == class_310.method_1551().field_1724) {
                cir.setReturnValue((Object)true);
            } else if ((Integer)Configs.NAMEPLATE_RENDER.value == 2 || (Integer)Configs.NAMEPLATE_RENDER.value == 1 && livingEntity != FiguraMod.extendedPickEntity) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"isEntityUpsideDown"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isEntityUpsideDown(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        Boolean upsideDown;
        Avatar avatar = AvatarManager.getAvatar((class_1297)entity);
        if (RenderUtils.vanillaModelAndScript(avatar) && (upsideDown = avatar.luaRuntime.renderer.upsideDown) != null) {
            cir.setReturnValue((Object)upsideDown);
        }
    }
}

